import tensorflow as tf
import tensorflow_hub as hub
#use the required process for label embedding P1 or P2
import label_embedding_P1
#import label_embedding_P2
import article_embedding
import json
import numpy as np
from scipy import spatial



dataset_path=""
result_path=""

embed = hub.load(https://tfhub.dev/google/universal-sentence-encoder/4)

# Use the required model like Transformer model or DAN
#https://tfhub.dev/google/universal-sentence-encoder/4
#https://tfhub.dev/google/universal-sentence-encoder-large/5

LabelEmbedding= label_embedding_P1.compute_label_embedding(embed)
ArticleEmbedding= article_embedding.compute_article_embedding(embed)

for threshold in np.arange(0.0,1.0,0.05):
        final_article_list = []
        print("Threshold running for::",threshold)
        filename = str(threshold) + '_Medical_Data-set_annotated.json'
        for i in range(0, len(ArticleEmbedding)):
            inferred_label=[]
            final_article = {}
            for label in LabelEmbedding:
                cosine_dist = 1 - spatial.distance.cosine(LabelEmbedding[label], ArticleEmbedding[i]['Article Embedding'])
                if (cosine_dist > threshold):
                    inferred_label.append(label)
            final_article['Article Text'] = ArticleEmbedding[i]['Article Text']
            final_article['Inferred Article Label'] = inferred_label # inferred labels
            final_article['Label'] = ArticleEmbedding[i]['Label']  # ground truth labels added for evaluation
            final_article_list.append(final_article)

        with open(result_path+filename, 'w+', newline='\n') as f:
                    print("writing json::",filename)
                    json.dump(final_article_list, f, indent=4, separators=(',', ':'))

