import sys
sys.path.append('../')

from emb2emb.train import get_train_parser, train
import csv, os
from scipy.stats import lognorm, uniform
import numpy as np

hyperparams = ["adversarial_reconstruction_weight"]
hp_distribution = [uniform(loc = 0, scale = 1.0)]
num_samples = 25

if __name__ == "__main__":
    parser = get_train_parser()
    parser.add_argument("--csv_file", type=str, default="out.csv")
    params, unknown = parser.parse_known_args()
    if len(unknown) > 0:
        raise ValueError("Got unknown parameters " + str(unknown))
    
    # make sure to set seed for drawing the hyperparams
    np.random.seed(params.seed)
    
    # draw configurations
    configs = []
    for _ in range(num_samples):
        configs.append([hp_distribution[i].rvs(1)[0] for i in range(len(hyperparams))])
    print(configs)
    
    # execute each task
    for i, c in enumerate(configs):
        for j, h in enumerate(hyperparams):
            val = c[j]
            print(val)
            getattr(params, h) # throw exception if the hyperparam doesnt exist
            setattr(params, h, val)
            

        results = train(params)
        print(results)
        print("Config {}; dev-score {}".format(c, results["dev"]))
            
        final_results = {}
        final_results["dev"] = results["dev"]
        final_results["test"] = results["test"]
        final_results["cfg"] = os.path.basename(params.modeldir)
        for j, h in enumerate(hyperparams):
            final_results[h] = c[j]
        final_results['trial'] = i
    
        fields=['cfg', 'trial'] + hyperparams + ['dev', 'test']
        if os.path.exists(params.csv_file):
            mode = "a"
        else:
            mode = "w"
        with open(params.csv_file, mode) as csvfile:
            writer = csv.DictWriter(csvfile, fieldnames=fields)
        
            if mode == "w":
                writer.writeheader()
            
            writer.writerow(final_results)
            
