/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.List;
import simplenlg.features.ClauseStatus;
import simplenlg.features.Form;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;

public class CoordinateSPhraseSpec
extends SPhraseSpec
implements CoordinatePhrase<SPhraseSpec> {
    private CoordinatePhraseSet<SPhraseSpec> coordinator = new CoordinatePhraseSet<CoordinateSPhraseSpec>(this);
    boolean externalComp;

    public CoordinateSPhraseSpec(SPhraseSpec ... coords) {
        this.coordinator.addCoordinates(coords);
        this.externalComp = false;
    }

    @Override
    public Conjunction getConjunction() {
        return this.coordinator.getConjunction();
    }

    @Override
    public String getConjunctionAsString() {
        return this.coordinator.getConjunctionAsString();
    }

    @Override
    public void setConjunction(String conj) {
        this.coordinator.setConjunction(conj);
    }

    @Override
    public void setConjunction(Conjunction conj) {
        this.coordinator.setConjunction(conj);
    }

    @Override
    public List<SPhraseSpec> getCoordinates() {
        return this.coordinator.getCoordinates();
    }

    public void addCoordinates(SPhraseSpec ... coords) {
        this.coordinator.addCoordinates(coords);
    }

    public void setCoordinates(SPhraseSpec ... coords) {
        this.coordinator.clearCoordinates();
        this.addCoordinates(coords);
    }

    @Override
    public void suppressComplementiser(boolean comp) {
        this.suppressComp = comp;
        boolean daughterComp = this.isSubordinateClause() && this.getForm().equals(Form.GERUND) ? true : !comp;
        for (SPhraseSpec child : this.coordinator.coordinates) {
            child.suppressComplementiser(daughterComp);
        }
    }

    @Override
    public void setClauseStatus(ClauseStatus type) {
        super.setClauseStatus(type);
        for (SPhraseSpec child : this.coordinator.coordinates) {
            child.setClauseStatus(type);
            if (type != ClauseStatus.SUBORDINATE) continue;
            child.suppressComplementiser(true);
        }
    }

    @Override
    public void setComplementiser(Object comp) {
        this.complementiser = comp;
        for (SPhraseSpec child : this.coordinator.coordinates) {
            child.setComplementiser(comp);
        }
    }

    @Override
    public void setPassive(boolean pass) {
        for (SPhraseSpec child : this.coordinator.coordinates) {
            child.setPassive(pass);
        }
    }

    @Override
    public void setForm(Form f) {
        super.setForm(f);
        for (SPhraseSpec s : this.coordinator.coordinates) {
            s.setForm(f);
        }
    }

    @Override
    public void setTense(Tense t) {
        super.setTense(t);
        for (SPhraseSpec s : this.coordinator.coordinates) {
            s.setTense(t);
        }
    }

    @Override
    public void setPerfect(boolean perf) {
        for (SPhraseSpec child : this.coordinator.coordinates) {
            child.setPerfect(perf);
        }
    }

    public void setEnforceComma(boolean enforceComma) {
        this.coordinator.setEnforceComma(enforceComma);
    }

    public boolean isEnforceComma() {
        return this.coordinator.isEnforceComma();
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof CoordinateSPhraseSpec) {
            CoordinateSPhraseSpec c = (CoordinateSPhraseSpec)o;
            eq = c.coordinator.equals(this.coordinator);
        }
        return eq;
    }

    @Override
    String realise(Realiser r) {
        String mainSent = this.coordinator.realise(r);
        if (this.isSubordinateClause() && !this.suppressComp && !this.getForm().equals(Form.GERUND)) {
            if (this.isRelativeWithComplementPosition()) {
                ((NPPhraseSpec)this.complementiser).setCase(this.relArgument.getCaseValue());
            }
            mainSent = r.appendSpace(r.realise(this.complementiser), mainSent);
        }
        return this.hasParentSpec() ? mainSent : r.applySentenceOrthography(mainSent);
    }
}

