/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.HashSet;
import java.util.Set;
import simplenlg.features.AuxType;
import simplenlg.features.Category;
import simplenlg.features.ComplementFrame;
import simplenlg.features.Form;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.features.VerbType;
import simplenlg.features.WordMorph;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.VerbInflection;
import simplenlg.lexicon.morph.VerbInflectionPattern;
import simplenlg.lexicon.verbnet.VerbnetClass;
import simplenlg.lexicon.verbnet.VerbnetFrame;

public class Verb
extends ContentWord {
    String presentParticipleForm;
    String present_3SG;
    String pastTenseForm;
    String pastParticipleForm;
    String particle;
    String verbPrefix = "";
    String presentStem;
    String pastStem;
    String subjunctiveStem;
    String presentParticiple;
    String perfectParticiple;
    String alternatePresentStem;
    AuxType auxType;
    VerbInflectionPattern pattern;
    VerbType type;
    Set<VerbnetClass> verbnetClasses;
    boolean allowsPassive;
    boolean allowsDative;
    boolean monotrans;
    boolean ditrans;
    boolean cplxtrans;
    boolean link;

    public Verb(String baseform) {
        if (baseform.indexOf("|") > 0) {
            int sepIndex = baseform.indexOf("|");
            String p = baseform.substring(0, sepIndex);
            if (!p.equals("")) {
                this.setVerbPrefix(p);
            }
            this.baseForm = baseform.substring(sepIndex + 1);
        } else {
            this.baseForm = baseform;
        }
        this.presentStem = VerbInflection.detectStem(this.baseForm);
        this.pastStem = this.presentStem + "te";
        this.perfectParticiple = "ge" + this.presentStem + "t";
        this.presentParticiple = this.baseForm.concat("d");
        this.alternatePresentStem = "";
        this.subjunctiveStem = this.pastStem;
        this.auxType = AuxType.HABEN;
        this.pattern = Constants.VERB_INFLECTION_DEFAULT;
        this.setCitationForm(this.baseForm);
        this.category = Category.VERB;
        this.type = VerbType.MAIN;
        this.verbnetClasses = new HashSet<VerbnetClass>();
        this.allowsDative = false;
        this.allowsPassive = false;
        this.monotrans = false;
        this.ditrans = false;
        this.cplxtrans = false;
        this.link = false;
    }

    public Verb(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Verb(String baseform, String pastStem, String perfPart, String altSgStem, String subjStem, AuxType auxType) {
        this(baseform);
        this.pastStem = pastStem;
        this.perfectParticiple = perfPart;
        this.alternatePresentStem = altSgStem;
        this.subjunctiveStem = subjStem;
        this.auxType = auxType;
    }

    public Verb(String baseform, String pastStem, String perfPart, String altSgStem, String subjStem, AuxType auxType, VerbInflectionPattern ptrn) {
        this(baseform, pastStem, perfPart, altSgStem, subjStem, auxType);
        this.pattern = ptrn;
    }

    public Verb(String baseform, String pastStem, String perfPart, String altSgStem, String subjStem, AuxType auxType, VerbType vt, VerbInflectionPattern ptrn) {
        this(baseform, pastStem, perfPart, altSgStem, subjStem, auxType, ptrn);
        this.type = vt;
        if (vt == VerbType.MODAL) {
            ptrn.addFeature(WordMorph.MODAL_INFLECTION);
        }
    }

    public Verb(String baseform, String pastStem, String perfPart, String altSgStem, String subjStem, String presPart, AuxType auxType, VerbInflectionPattern ptrn) {
        this(baseform, pastStem, perfPart, altSgStem, subjStem, auxType, ptrn);
        this.presentParticiple = presPart;
    }

    public Verb(String baseform, String pastStem, String perfPart, String altSgStem, String subjStem, String presPart, AuxType auxType, VerbType vt, VerbInflectionPattern ptrn) {
        this(baseform, pastStem, perfPart, altSgStem, subjStem, presPart, auxType, ptrn);
        this.type = vt;
    }

    public Verb(String baseform, VerbInflectionPattern ptrn) {
        this(baseform);
        this.pattern = ptrn;
    }

    @Deprecated
    public Verb(String baseform, LexiconInterface lex) {
        this(baseform);
        this.parentLexicon = lex;
    }

    public void addVerbnetClass(VerbnetClass vnClass) {
    }

    public boolean hasVerbnetClass() {
        return !this.verbnetClasses.isEmpty();
    }

    public Set<VerbnetFrame> getVerbnetFrames() {
        HashSet<VerbnetFrame> frames = new HashSet<VerbnetFrame>();
        for (VerbnetClass vnClass : this.verbnetClasses) {
            frames.addAll(vnClass.getFrames());
        }
        return frames;
    }

    @Override
    public void addComplementFrame(ComplementFrame frame) {
        super.addComplementFrame(frame);
        if (frame.allowsDativeShift()) {
            this.allowsDative = true;
        }
        if (frame.allowsPassive()) {
            this.allowsPassive = true;
        }
        switch (1.$SwitchMap$simplenlg$features$Transitivity[frame.getTransitivity().ordinal()]) {
            case 1: {
                this.monotrans = true;
                break;
            }
            case 2: {
                this.ditrans = true;
                break;
            }
            case 3: {
                this.cplxtrans = true;
                break;
            }
            case 4: {
                this.link = true;
            }
        }
    }

    public boolean allowsPassiveRaising() {
        return this.allowsPassive;
    }

    public boolean allowsDativeShift() {
        return this.allowsDative;
    }

    public void setParticle(String part) {
        this.particle = part;
    }

    public void setParticle(LexicalItem part) {
        this.particle = part.getBaseForm();
    }

    public String getParticle() {
        return this.particle;
    }

    public String getVerbPrefix() {
        return this.verbPrefix;
    }

    public void setVerbPrefix(String verbPrefix) {
        this.verbPrefix = verbPrefix;
    }

    public boolean hasVerbPrefix() {
        return this.verbPrefix != null && !this.verbPrefix.equals("");
    }

    public String getPresentStem() {
        return this.presentStem;
    }

    public void setPresentStem(String presentStem) {
        this.presentStem = presentStem;
    }

    public String getPastStem() {
        return this.pastStem;
    }

    public void setPastStem(String pastStem) {
        this.pastStem = pastStem;
    }

    public String getSubjunctiveStem() {
        if (this.subjunctiveStem.isEmpty()) {
            return this.getPastStem();
        }
        return this.subjunctiveStem;
    }

    public void setSubjunctiveStem(String subjunctiveStem) {
        this.subjunctiveStem = subjunctiveStem;
    }

    public String getPerfectParticiple() {
        return this.render(this.perfectParticiple);
    }

    public void setPerfectParticiple(String perfectParticiple) {
        this.perfectParticiple = perfectParticiple;
    }

    public void setPresentParticiple(String presentParticiple) {
        this.presentParticiple = presentParticiple;
    }

    public String getAlternatePresentStem() {
        if (this.hasAlternatePresentStem()) {
            return this.alternatePresentStem;
        }
        return this.presentStem;
    }

    public void setAlternatePresentStem(String alternatePresentStem) {
        this.alternatePresentStem = alternatePresentStem;
    }

    public boolean hasAlternatePresentStem() {
        return this.alternatePresentStem != null && !this.alternatePresentStem.isEmpty();
    }

    public VerbInflectionPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(VerbInflectionPattern pattern) {
        this.pattern = pattern;
    }

    public AuxType getAuxType() {
        return this.auxType;
    }

    public void setAuxType(AuxType auxType) {
        this.auxType = auxType;
    }

    public String getInfinitiveStem() {
        return this.baseForm;
    }

    @Override
    public String getBaseForm() {
        if (this.hasVerbPrefix()) {
            String separator = this.verbPrefix.endsWith(" ") ? "" : "|";
            return this.verbPrefix + separator + this.baseForm;
        }
        return this.baseForm;
    }

    public String getBaseform(boolean includeParticle) {
        if (includeParticle) {
            return this.render(this.baseForm);
        }
        return this.baseForm;
    }

    public String getForm(Person p, NumberAgr n, Tense t, Form f) {
        return this.pattern.apply(this, p, n, t, f);
    }

    public String getImperativeForm(NumberAgr n) {
        return this.getForm(null, n, null, Form.IMPERATIVE);
    }

    public String getHonorificImperativeForm() {
        if (this.pattern.equals(Constants.VERB_INFLECTION_TUN)) {
            return "tun Sie";
        }
        return this.getForm(Person.THIRD, NumberAgr.PLURAL, Tense.PRESENT, Form.SUBJUNCTIVE).concat(" Sie");
    }

    public boolean isPhrasalVerb() {
        return this.particle != null;
    }

    public boolean isCopular() {
        return this.baseForm.equalsIgnoreCase("be");
    }

    @Deprecated
    public void setIsNullAffixVerb(boolean neverInflected) {
        if (neverInflected) {
            this.pastParticipleForm = this.baseForm;
            this.pastTenseForm = this.baseForm;
            this.present_3SG = this.baseForm;
            this.presentParticipleForm = this.baseForm;
        }
        this.inflectionType = InflectionType.INVARIANT;
    }

    @Deprecated
    public boolean isNullAffixVerb() {
        return this.inflectionType == InflectionType.INVARIANT;
    }

    @Override
    public void setInflectionType(InflectionType t) {
        super.setInflectionType(t);
        if (t.equals(InflectionType.INVARIANT)) {
            this.pastParticipleForm = this.baseForm;
            this.pastTenseForm = this.baseForm;
            this.present_3SG = this.baseForm;
            this.presentParticipleForm = this.baseForm;
        }
    }

    public void setVerbType(VerbType type) {
        this.type = type;
        if (this.type == VerbType.MODAL) {
            this.setInflectionType(InflectionType.INVARIANT);
        }
    }

    public VerbType getVerbType() {
        return this.type;
    }

    public boolean isModalVerb() {
        return this.type.equals(VerbType.MODAL);
    }

    public boolean isAuxiliaryVerb() {
        return this.type.equals(VerbType.AUX);
    }

    public String getPastParticiple() {
        if (this.pastParticipleForm == null) {
            this.pastParticipleForm = VerbInflection.PAST_PARTICIPLE.apply(this);
        }
        return this.render(this.pastParticipleForm);
    }

    public void setPastParticiple(String ppart) {
        this.pastParticipleForm = ppart;
    }

    public String getPresentParticiple() {
        return this.render(this.presentParticiple);
    }

    public String getInfinitive() {
        return this.render(this.baseForm);
    }

    public String getZuInfinitive() {
        String inf = this.verbPrefix;
        String zu = inf.equals("") || inf.endsWith(" ") ? "zu " : "zu";
        inf = inf + zu + this.baseForm;
        return inf;
    }

    public boolean isIntransitive() {
        return !this.monotrans && !this.ditrans && !this.cplxtrans;
    }

    public boolean isMonotransitive() {
        return this.monotrans;
    }

    public boolean isDitransitive() {
        return this.ditrans;
    }

    public boolean isComplextransitive() {
        return this.cplxtrans;
    }

    public boolean isLinkingVerb() {
        return this.link;
    }

    public int getNumComplements() {
        return this.complementationFrames.size();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            Verb v = (Verb)o;
            return this.particle == v.particle || this.particle.equals(v.particle);
        }
        return false;
    }

    private String render(String morphForm) {
        return this.hasVerbPrefix() ? this.verbPrefix + morphForm : morphForm;
    }
}

