/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Deixis;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.InflectionType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Polarity;
import simplenlg.features.Possession;
import simplenlg.features.Quantification;
import simplenlg.features.Reflexivity;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.morph.InflectionPattern;

public class Pronoun
extends Noun {
    Polarity polarity;
    Quantification quantification;
    Possession possession;
    Reflexivity reflexivity;
    Deixis deixis;
    Case caseValue;
    Person person = null;
    NumberAgr number = null;
    Gender gender = null;
    String objectForm;
    boolean expletive;
    String accSg;
    String genSg;
    String datSg;
    String nomPl;
    String accPl;
    String genPl;
    String datPl;
    InflectionPattern<Pronoun> nounPattern;
    InflectionPattern<Pronoun> articlePattern;
    boolean usePattern;

    public Pronoun(String base) {
        super(base);
        this.category = Category.PRONOUN;
        this.expletive = false;
        this.inflectionType = InflectionType.INVARIANT;
        this.agreement = Agreement.COUNT;
        this.caseValue = Case.NOM_ACC;
        this.possession = null;
        this.reflexivity = Reflexivity.NON_REFLEXIVE;
        this.quantification = Quantification.DEFINITE;
        this.deixis = Deixis.NON_DEMONSTRATIVE;
        this.accSg = this.baseForm;
        this.genSg = this.baseForm;
        this.datSg = this.baseForm;
        this.nomPl = this.baseForm;
        this.accPl = this.baseForm;
        this.genPl = this.baseForm;
        this.datPl = this.baseForm;
        this.articlePattern = null;
        this.nounPattern = null;
        this.usePattern = false;
    }

    public Pronoun(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Pronoun(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    @Deprecated
    public Pronoun(String base, LexiconInterface lex) {
        this(base);
        this.parentLexicon = lex;
    }

    public Pronoun(String base, Person p, NumberAgr n, Gender g) {
        this(base);
        this.person = p;
        this.number = n;
        this.gender = g;
    }

    public Pronoun(String base, Case c, Person p, NumberAgr n, Gender g) {
        this(base);
        this.caseValue = c;
        this.person = p;
        this.number = n;
        this.gender = g;
    }

    @Deprecated
    public Pronoun(String base, String objform, Person p, NumberAgr n, Gender g) {
        this(base, p, n, g);
        this.objectForm = objform;
    }

    public Pronoun(String base, Person p, NumberAgr n, Gender g, boolean expl) {
        this(base, p, n, g);
        this.expletive = expl;
    }

    @Deprecated
    public Pronoun(String base, String objform, Person p, NumberAgr n, Gender g, boolean expl) {
        this(base, objform, p, n, g);
        this.expletive = expl;
    }

    public Pronoun(String base, String accSg, String genSg, String datSg, String nomPl, String accPl, String genPl, String datPl, Person p, Gender g) {
        this(base, p, null, g);
        this.accSg = accSg;
        this.genSg = genSg;
        this.datSg = datSg;
        this.nomPl = nomPl;
        this.accPl = accPl;
        this.genPl = genPl;
        this.datPl = datPl;
    }

    public Pronoun(String base, InflectionPattern<Pronoun> articlePattern, InflectionPattern<Pronoun> nounPattern) {
        this(base);
        this.articlePattern = articlePattern;
        this.nounPattern = nounPattern;
        this.usePattern = true;
    }

    public Pronoun(String base, InflectionPattern<Pronoun> articlePattern, InflectionPattern<Pronoun> nounPattern, Person p) {
        this(base, articlePattern, nounPattern);
        this.person = p;
    }

    public Pronoun(String base, InflectionPattern<Pronoun> articlePattern, InflectionPattern<Pronoun> nounPattern, Person p, Gender g) {
        this(base, articlePattern, nounPattern);
        this.person = p;
        this.gender = g;
    }

    public Pronoun(String base, InflectionPattern<Pronoun> articlePattern, InflectionPattern<Pronoun> nounPattern, Person p, NumberAgr n) {
        this(base, articlePattern, nounPattern);
        this.person = p;
        this.number = n;
    }

    public Pronoun(String base, InflectionPattern<Pronoun> articlePattern, InflectionPattern<Pronoun> nounPattern, Person p, NumberAgr n, Gender g) {
        this(base, articlePattern, nounPattern);
        this.person = p;
        this.number = n;
        this.gender = g;
    }

    public Person getPerson() {
        return this.person;
    }

    @Override
    public NumberAgr getNumber() {
        return this.number;
    }

    @Deprecated
    public String getForm(DiscourseFunction function) {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[function.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (this.objectForm == null) break;
                return this.objectForm;
            }
        }
        return this.baseForm;
    }

    public String getForm(Case cas, NumberAgr num, Gender gen) {
        if (this.nounPattern != null) {
            return this.nounPattern.apply(this.baseForm, cas, num, gen);
        }
        boolean plural = num == NumberAgr.PLURAL;
        switch (1.$SwitchMap$simplenlg$features$Case[cas.ordinal()]) {
            case 1: {
                return plural ? this.accPl : this.accSg;
            }
            case 2: {
                return plural ? this.genPl : this.genSg;
            }
            case 3: {
                return plural ? this.datPl : this.datSg;
            }
        }
        return plural ? this.nomPl : this.baseForm;
    }

    public String getSpecifierForm(Case cas, NumberAgr num, Gender gen) {
        if (this.articlePattern != null) {
            return this.articlePattern.apply(this.baseForm, cas, num, gen);
        }
        return this.getForm(cas, num, gen);
    }

    @Override
    @Deprecated
    public String getForm(Case cas, NumberAgr num) {
        return this.getForm(cas, num, this.gender);
    }

    public String getPredicativeForm() {
        return this.objectForm;
    }

    @Deprecated
    public static Pronoun getPersonalPronoun(Person p, NumberAgr n, Gender g) {
        return Constants.getPersonalPronoun(p);
    }

    @Deprecated
    public static Pronoun getPossessivePronoun(Person p, NumberAgr n, Gender g) {
        return Constants.getPossessivePronoun(p, n, g);
    }

    @Deprecated
    public static Pronoun getPronoun(String baseform) {
        return Constants.getPronoun(baseform);
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
    }

    public Quantification getQuantification() {
        return this.quantification;
    }

    public void setQuantification(Quantification quantification) {
        this.quantification = quantification;
    }

    public Possession getPossession() {
        return this.possession;
    }

    public void setPossession(Possession possession) {
        this.possession = possession;
    }

    public Reflexivity getReflexivity() {
        return this.reflexivity;
    }

    public void setReflexivity(Reflexivity reflexivity) {
        this.reflexivity = reflexivity;
    }

    public Deixis getDeixis() {
        return this.deixis;
    }

    public void setDeixis(Deixis deixis) {
        this.deixis = deixis;
    }

    public Case getCaseValue() {
        return this.caseValue;
    }

    public void setCaseValue(Case caseValue) {
        this.caseValue = caseValue;
    }

    @Override
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Override
    public Gender getGender() {
        return this.gender;
    }

    public void setExpletive(boolean expletive) {
        this.expletive = expletive;
    }

    public boolean isExpletive() {
        return this.expletive;
    }

    public boolean hasForm(String form) {
        if (this.articlePattern != null) {
            for (Gender g : Gender.values()) {
                for (NumberAgr n : NumberAgr.values()) {
                    for (Case c : Case.values()) {
                        if (!this.articlePattern.apply(this.baseForm, c, n, g).equalsIgnoreCase(form)) continue;
                        return true;
                    }
                }
            }
        }
        if (this.nounPattern != null) {
            for (Gender g : Gender.values()) {
                for (NumberAgr n : NumberAgr.values()) {
                    for (Case c : Case.values()) {
                        if (!this.nounPattern.apply(this.baseForm, c, n, g).equalsIgnoreCase(form)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

