/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SimpleGoodTuring {
    private static final int MIN_INPUT = 5;
    private static final double CONFID_FACTOR = 1.96;
    private static final double TOLERANCE = 1.0E-12;
    private int[] r;
    private int[] n;
    private int rows;
    private int bigN = 0;
    private double pZero;
    private double bigNPrime;
    private double slope;
    private double intercept;
    private double[] z;
    private double[] logR;
    private double[] logZ;
    private double[] rStar;
    private double[] p;

    public SimpleGoodTuring(int[] r, int[] n) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null!");
        }
        if (n == null) {
            throw new IllegalArgumentException("n must not be null!");
        }
        if (r.length != n.length) {
            throw new IllegalArgumentException("r and n must have same size!");
        }
        if (r.length < 5) {
            throw new IllegalArgumentException("r must have size >= 5!");
        }
        this.r = new int[r.length];
        this.n = new int[n.length];
        System.arraycopy(r, 0, this.r, 0, r.length);
        System.arraycopy(n, 0, this.n, 0, n.length);
        this.rows = r.length;
        this.compute();
        this.validate(1.0E-12);
    }

    public double getProbabilityForUnseen() {
        return this.pZero;
    }

    public double[] getProbabilities() {
        return this.p;
    }

    private void compute() {
        int j;
        boolean indiffValsSeen = false;
        this.z = new double[this.rows];
        this.logR = new double[this.rows];
        this.logZ = new double[this.rows];
        this.rStar = new double[this.rows];
        this.p = new double[this.rows];
        for (j = 0; j < this.rows; ++j) {
            this.bigN += this.r[j] * this.n[j];
        }
        int next_n = this.row(1);
        this.pZero = next_n < 0 ? 0.0 : (double)this.n[next_n] / (double)this.bigN;
        for (j = 0; j < this.rows; ++j) {
            int i = j == 0 ? 0 : this.r[j - 1];
            double k = j == this.rows - 1 ? (double)(2 * this.r[j] - i) : (double)this.r[j + 1];
            this.z[j] = (double)(2 * this.n[j]) / (k - (double)i);
            this.logR[j] = Math.log(this.r[j]);
            this.logZ[j] = Math.log(this.z[j]);
        }
        this.findBestFit();
        for (j = 0; j < this.rows; ++j) {
            double y = (double)(this.r[j] + 1) * this.smoothed(this.r[j] + 1) / this.smoothed(this.r[j]);
            if (this.row(this.r[j] + 1) < 0) {
                indiffValsSeen = true;
            }
            if (!indiffValsSeen) {
                next_n = this.n[this.row(this.r[j] + 1)];
                double x = (double)((this.r[j] + 1) * next_n) / (double)this.n[j];
                if (Math.abs(x - y) <= 1.96 * Math.sqrt(SimpleGoodTuring.sq((double)this.r[j] + 1.0) * (double)next_n / SimpleGoodTuring.sq(this.n[j]) * (1.0 + (double)next_n / (double)this.n[j]))) {
                    indiffValsSeen = true;
                } else {
                    this.rStar[j] = x;
                }
            }
            if (!indiffValsSeen) continue;
            this.rStar[j] = y;
        }
        this.bigNPrime = 0.0;
        for (j = 0; j < this.rows; ++j) {
            this.bigNPrime += (double)this.n[j] * this.rStar[j];
        }
        for (j = 0; j < this.rows; ++j) {
            this.p[j] = (1.0 - this.pZero) * this.rStar[j] / this.bigNPrime;
        }
    }

    private int row(int freq) {
        int i;
        for (i = 0; i < this.rows && this.r[i] < freq; ++i) {
        }
        return i < this.rows && this.r[i] == freq ? i : -1;
    }

    private void findBestFit() {
        int i;
        double meanY = 0.0;
        double meanX = 0.0;
        double Xsquares = 0.0;
        double XYs = 0.0;
        for (i = 0; i < this.rows; ++i) {
            meanX += this.logR[i];
            meanY += this.logZ[i];
        }
        meanX /= (double)this.rows;
        meanY /= (double)this.rows;
        for (i = 0; i < this.rows; ++i) {
            XYs += (this.logR[i] - meanX) * (this.logZ[i] - meanY);
            Xsquares += SimpleGoodTuring.sq(this.logR[i] - meanX);
        }
        this.slope = XYs / Xsquares;
        this.intercept = meanY - this.slope * meanX;
    }

    private double smoothed(int i) {
        return Math.exp(this.intercept + this.slope * Math.log(i));
    }

    private static double sq(double x) {
        return x * x;
    }

    private void print() {
        System.out.printf("%6s %6s %8s %8s%n", "r", "n", "p", "p*");
        System.out.printf("%6s %6s %8s %8s%n", "----", "----", "----", "----");
        System.out.printf("%6d %6d %8.4g %8.4g%n", 0, 0, 0.0, this.pZero);
        for (int i = 0; i < this.rows; ++i) {
            System.out.printf("%6d %6d %8.4g %8.4g%n", this.r[i], this.n[i], 1.0 * (double)this.r[i] / (double)this.bigN, this.p[i]);
        }
    }

    private void validate(double tolerance) {
        double sum = this.pZero;
        for (int i = 0; i < this.n.length; ++i) {
            sum += (double)this.n[i] * this.p[i];
        }
        double err2 = 1.0 - sum;
        if (Math.abs(err2) > tolerance) {
            throw new IllegalStateException("ERROR: the probability distribution sums to " + sum);
        }
    }

    private static int[][] readInput() throws Exception {
        String line;
        ArrayList<Integer> rVals = new ArrayList<Integer>();
        ArrayList<Integer> nVals = new ArrayList<Integer>();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String[] tokens = line.trim().split("\\s+");
            if (tokens.length != 2) {
                throw new Exception("Line doesn't contain two tokens: " + line);
            }
            Integer r = Integer.valueOf(tokens[0]);
            Integer n = Integer.valueOf(tokens[1]);
            rVals.add(r);
            nVals.add(n);
        }
        in.close();
        int[][] result = new int[][]{SimpleGoodTuring.integerList2IntArray(rVals), SimpleGoodTuring.integerList2IntArray(nVals)};
        return result;
    }

    private static int[] integerList2IntArray(List<Integer> integers) {
        int[] ints = new int[integers.size()];
        int i = 0;
        for (Integer integer : integers) {
            ints[i++] = integer;
        }
        return ints;
    }

    public static void main(String[] args) throws Exception {
        int[][] input = SimpleGoodTuring.readInput();
        SimpleGoodTuring sgt = new SimpleGoodTuring(input[0], input[1]);
        sgt.print();
    }
}

