#include "model.ih"

void Model::evalNorm()
{
    if (d_config->goldErrDet && d_origs[d_wordIdx] == d_cors[d_wordIdx])
        return;
    ++d_config->totalWords;

    if (!d_config->caps)
        for (size_t candIdx = 0; candIdx != d_cands[d_wordIdx].size(); ++candIdx)
            transform(d_cands[d_wordIdx][candIdx].begin(), d_cands[d_wordIdx][candIdx].end(), 
                    d_cands[d_wordIdx][candIdx].begin(), ::tolower);

    // For precision recall and F1 score
    string winner = (d_cands[d_wordIdx].empty())? d_origs[d_wordIdx]: d_cands[d_wordIdx][0];
    if (d_origs[d_wordIdx] != d_cors[d_wordIdx])
        ++d_config->goldTotalNormed;
    if (winner != d_origs[d_wordIdx])
        ++d_config->totalNormed;
    if (winner == d_cors[d_wordIdx] && d_origs[d_wordIdx] != d_cors[d_wordIdx])
        ++d_config->corNorm;
    
    if (d_cands[d_wordIdx].empty())
    {// not normalized!
        if (d_origs[d_wordIdx] == d_cors[d_wordIdx])
            ++d_config->recall[0];
        else
        {
            ++d_config->notFound;
            if (d_config->verbose)
                cout << "NN: " << d_origs[d_wordIdx] << '\t' << d_cors[d_wordIdx] <<'\n';
        }
        return;
    }
    // For accuracy (or WER)
    bool found = false;
    for (size_t corIdx = 0; corIdx != d_cands[d_wordIdx].size(); ++corIdx)
    {
        if (d_cands[d_wordIdx][corIdx] == d_cors[d_wordIdx])
        {
            ++d_config->recall[corIdx];
            found = true;
            if (d_config->verbose && corIdx != 0)
            {
                cout << "WR: " << d_origs[d_wordIdx] << " -> " << d_cors[d_wordIdx]  
                     << '\t' << d_cands[d_wordIdx].size() << '\n';
                for (size_t beg = 0; beg != corIdx+1; ++beg)
                    cout << ' ' << beg << ". " << d_cands[d_wordIdx][beg] << '\t' << d_results[d_wordIdx][beg] << '\n';
            }
            break;
        }
    }

    if (!found)
    {
        if (d_config->verbose)
            cout << "NF: " << d_origs[d_wordIdx] << '\t' << d_cors[d_wordIdx]
                 << '\t' << d_cands[d_wordIdx].size() << '\n';
        ++d_config->notFound;
    }
}

