#include "graphcjj2gc_prune_state.h"

namespace graphcjj2gc_prune {
	StateItem::StateItem() = default;
	StateItem::~StateItem() = default;

	void StateItem::init(const int & l, const int & r) {
		type = 0;
		left = l;
		right = r;
		exact_l2r_label.reset();
		exact_l2r_nolabel.reset();
		l2r_label.clear();
		l2r_nolabel.clear();
	}

	void StateItem::print() {
		std::cout << "[" << left << "," << right << "]" << std::endl;
		std::cout << "type is: ";
		switch (type) {
		case L2R_LABEL:
			std::cout << "L2R_COMP" << std::endl;
			std::cout << "split: " << l2r_label.bestItem().getSplit() << " score: " << l2r_label.bestItem().getScore() << std::endl;
			break;
		case L2R_NOLABEL:
			std::cout << "R2L_COMP" << std::endl;
			std::cout << "split: " << l2r_nolabel.bestItem().getSplit() << " score: " << l2r_nolabel.bestItem().getScore() << std::endl;
			break;
		default:
			std::cout << "ZERO" << std::endl;
			std::cout << "L2R_LABEL" << std::endl;
			std::cout << "split: " << l2r_label.bestItem().getSplit() << " score: " << l2r_label.bestItem().getScore() << std::endl;
			std::cout << "L2R_NOLABEL" << std::endl;
			std::cout << "split: " << l2r_nolabel.bestItem().getSplit() << " score: " << l2r_nolabel.bestItem().getScore() << std::endl;
	
			break;
		}
	}
}