/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import jigsaw.syntax.Lexicon;
import jigsaw.syntax.ParserException;
import jigsaw.syntax.Rule;
import jigsaw.syntax.SymbolTable;

public class Grammar
implements Serializable {
    private static final long serialVersionUID = 3779488872217828209L;
    private Lexicon _l = null;
    private SymbolTable _ts = new SymbolTable();
    private SymbolTable _nts = new SymbolTable();
    private Vector<Rule> _rules = new Vector();
    private HashMap<Rule, Rule> _rulemap = new HashMap();
    private Vector<Rule> _trules = new Vector();
    private Vector<Rule> _chainrules = new Vector();
    private Vector<Rule> _birules = new Vector();
    private Vector<Rule> _norules = new Vector();
    private Vector<Rule>[] _idx_rules = null;
    private Vector<Rule>[] _idx_birules = null;
    private Vector<Rule>[] _idx_trules = null;
    private Vector<Rule>[] _idx_chainrules = null;
    private Vector<Rule>[] _idx_rev_chainrules = null;
    private double[] _logprob = null;
    private int _start = 0;
    public static final char MODPREFIX = '@';
    private BitSet[] _chainvec = null;

    public Grammar() {
        this._l = new Lexicon(this._ts);
    }

    public Grammar(Lexicon lex) {
        this._l = lex;
        this._ts = this._l.tags();
    }

    public Lexicon lexicon() {
        return this._l;
    }

    public void buildProb() {
        this._logprob = new double[this._rules.size()];
        int[] lhssum = new int[this._nts.size()];
        int i = 0;
        while (i < lhssum.length) {
            lhssum[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this._logprob.length) {
            int lhs = this._rules.get(i).lhs();
            if (lhssum[lhs] == 0) {
                for (Rule r : this.rules(lhs)) {
                    int n = lhs;
                    lhssum[n] = lhssum[n] + r.freq();
                }
            }
            this._logprob[i] = Math.log((double)this._rules.get(i).freq() / (double)lhssum[lhs]);
            ++i;
        }
    }

    public void analyzeConnectivity() {
        BitSet[] offspring = new BitSet[this._nts.size()];
        for (Rule r : this._rules) {
            if (offspring[r.lhs()] == null) {
                offspring[r.lhs()] = new BitSet(this._nts.size());
                offspring[r.lhs()].set(r.lhs());
            }
            int[] nArray = r.rhs();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                if (c >= 0) {
                    offspring[r.lhs()].set(c);
                }
                ++n2;
            }
        }
        boolean changed = true;
        int iter = 0;
        while (changed) {
            changed = false;
            ++iter;
            int i = 0;
            while (i < this._nts.size()) {
                int j = 0;
                while (j < this._nts.size()) {
                    if (i != j && offspring[i].get(j)) {
                        int card = offspring[i].cardinality();
                        offspring[i].or(offspring[j]);
                        if (card != offspring[i].cardinality()) {
                            changed = true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        System.err.println("Closure found in " + iter + " iterations");
        int A = 0;
        while (A < this._nts.size()) {
            System.out.print(String.valueOf(this.NT(A)) + "\t" + offspring[A].cardinality() + "\t");
            int i = offspring[A].nextSetBit(0);
            while (i >= 0) {
                if (this.NT(i).startsWith("@T")) {
                    System.out.print(" " + this.T(this.trules(i).firstElement().rhs()[0]));
                } else {
                    System.out.print(" " + this.NT(i));
                }
                i = offspring[A].nextSetBit(i + 1);
            }
            System.out.println();
            ++A;
        }
    }

    public double logProb(int ridx) {
        return this._logprob[ridx];
    }

    public Vector<Rule> rules() {
        return this._rules;
    }

    public Vector<Rule> birules() {
        return this._birules;
    }

    public Vector<Rule> trules() {
        return this._trules;
    }

    public Vector<Rule> chainrules() {
        return this._chainrules;
    }

    public Vector<Rule> rules(int lhs) {
        if (this._idx_rules[lhs] != null) {
            return this._idx_rules[lhs];
        }
        return this._norules;
    }

    public Vector<Rule> birules(int lhs) {
        if (this._idx_birules[lhs] != null) {
            return this._idx_birules[lhs];
        }
        return this._norules;
    }

    public Vector<Rule> trules(int lhs) {
        if (this._idx_trules[lhs] != null) {
            return this._idx_trules[lhs];
        }
        return this._norules;
    }

    public Vector<Rule> chainrules(int lhs) {
        if (this._idx_chainrules[lhs] != null) {
            return this._idx_chainrules[lhs];
        }
        return this._norules;
    }

    public Vector<Rule> revchainrules(int rhs) {
        if (this._idx_rev_chainrules[rhs] != null) {
            return this._idx_rev_chainrules[rhs];
        }
        return this._norules;
    }

    public void loadProbGrammar(String filename) throws IOException, ParserException {
        String[] toks;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = null;
        ArrayList<Double> logprobs = new ArrayList<Double>();
        while ((line = br.readLine()) != null) {
            toks = line.split("\\s+");
            if (toks.length < 4) {
                throw new ParserException("Invalid line in grammar " + filename);
            }
            if (toks[0].equals(toks[2]) && toks[3].equals("1.0")) continue;
            this._nts.register(toks[0].substring(0, toks[0].indexOf(95)));
        }
        br.close();
        br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            toks = line.split("\\s+");
            if (toks[0].equals(toks[2]) && toks[3].equals("1.0")) continue;
            int lhs = this._nts.lookup(toks[0].substring(0, toks[0].indexOf(95)));
            int[] rhs = new int[toks.length - 3];
            int i = 0;
            while (i < rhs.length) {
                int r = this._nts.lookup(toks[i + 2].substring(0, toks[i + 2].indexOf(95)));
                if (r != -1) {
                    rhs[i] = r;
                } else {
                    r = this._ts.register(toks[i + 2].substring(0, toks[i + 2].indexOf(95)));
                    rhs[i] = -r - 2;
                }
                ++i;
            }
            Rule rule = new Rule(lhs, rhs, 0);
            this._rules.add(rule);
            logprobs.add(Math.log(Double.parseDouble(toks[toks.length - 1])));
        }
        br.close();
        this.preterminalize();
        this._logprob = new double[this._rules.size()];
        int i = 0;
        while (i < this._logprob.length) {
            this._logprob[i] = i < logprobs.size() ? (Double)logprobs.get(i) : 0.0;
            ++i;
        }
        this.indexRules();
    }

    public void loadGrammar(String filename) throws IOException, ParserException {
        String[] toks;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = null;
        while ((line = br.readLine()) != null) {
            toks = line.split("\\s+");
            if (toks.length < 3) {
                throw new ParserException("Invalid line in grammar " + filename);
            }
            this._nts.register(toks[1]);
        }
        br.close();
        br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            toks = line.split("\\s+");
            int lhs = this._nts.lookup(toks[1]);
            int[] rhs = new int[toks.length - 2];
            int i = 0;
            while (i < rhs.length) {
                int r = this._nts.lookup(toks[i + 2]);
                if (r != -1) {
                    rhs[i] = r;
                } else {
                    r = this._ts.register(toks[i + 2]);
                    rhs[i] = -r - 2;
                }
                ++i;
            }
            Rule rule = new Rule(lhs, rhs, Integer.parseInt(toks[0]));
            this._rules.add(rule);
        }
        br.close();
    }

    public void loadGrammar(String gfile, String lfile) throws IOException, ParserException {
        String[] toks;
        BufferedReader br = new BufferedReader(new FileReader(gfile));
        String line = null;
        while ((line = br.readLine()) != null) {
            toks = line.split("\\s+");
            if (toks.length < 3) {
                throw new ParserException("Invalid line in grammar " + gfile);
            }
            int lhs = this._nts.register(toks[1]);
            int[] rhs = new int[toks.length - 2];
            int i = 0;
            while (i < rhs.length) {
                rhs[i] = this._nts.register(toks[i + 2]);
                ++i;
            }
            Rule rule = new Rule(lhs, rhs, Integer.parseInt(toks[0]));
            this._rules.add(rule);
        }
        br.close();
        br = new BufferedReader(new FileReader(lfile));
        while ((line = br.readLine()) != null) {
            toks = line.split("\\t");
            if (toks.length < 2) {
                throw new ParserException("Invalid line in lexicon " + lfile);
            }
            int t = this._ts.register(toks[0]);
            int i = 1;
            while (i < toks.length) {
                String[] parts = toks[i].split(" ");
                Rule rule = new Rule(this._nts.register(parts[0]), new int[]{-t - 2}, Integer.parseInt(parts[1]));
                this._rules.add(rule);
                ++i;
            }
        }
        br.close();
    }

    public void incrSeenCount(Rule r) {
        if (this._rulemap.containsKey(r)) {
            Rule rule = this._rulemap.get(r);
            rule.incr();
        } else {
            r.incr();
            this._rules.add(r);
            this._rulemap.put(r, r);
        }
    }

    public void incrSeenCount(String word, int tag, int count) {
        this._l.incrSeenCount(word, tag, count);
    }

    public String T(int t) {
        return this._ts.lookup(-t - 2);
    }

    public int T(String t) {
        return -this._ts.lookup(t) - 2;
    }

    public int T2i(int t) {
        return -t - 2;
    }

    public int i2T(int i) {
        return -i - 2;
    }

    public String NT(int nt) {
        return this._nts.lookup(nt);
    }

    public int NT(String nt) {
        return this._nts.lookup(nt);
    }

    public String Symbol(int x) {
        if (x == -1) {
            return null;
        }
        if (x > 0) {
            return this.NT(x);
        }
        return this.T(x);
    }

    public SymbolTable nts() {
        return this._nts;
    }

    public SymbolTable ts() {
        return this._ts;
    }

    public String Start() {
        return this._nts.lookup(this._start);
    }

    public int S() {
        return this._start;
    }

    public int registerNT(String nt) {
        return this._nts.register(nt);
    }

    public int registerT(String t) {
        return -this._ts.register(t) - 2;
    }

    public int registerS(String s) {
        this._start = this._nts.register(s);
        return this._start;
    }

    public void normalize() {
        this.preterminalize();
        this.binarize();
        this.topoSort();
        this.indexRules();
    }

    public void indexRules() {
        this._idx_rules = new Vector[this._nts.size()];
        this._idx_birules = new Vector[this._nts.size()];
        this._idx_trules = new Vector[this._nts.size()];
        this._idx_chainrules = new Vector[this._nts.size()];
        this._idx_rev_chainrules = new Vector[this._nts.size()];
        int id = 0;
        for (Rule r : this._rules) {
            r.id(id++);
            if (this._idx_rules[r.lhs()] == null) {
                this._idx_rules[r.lhs()] = new Vector();
            }
            this._idx_rules[r.lhs()].add(r);
            if (r.arity() == 2) {
                this._birules.add(r);
                if (this._idx_birules[r.lhs()] == null) {
                    this._idx_birules[r.lhs()] = new Vector();
                }
                this._idx_birules[r.lhs()].add(r);
                continue;
            }
            if (r.arity() != 1) continue;
            if (r.rhs()[0] >= 0) {
                this._chainrules.add(r);
                if (this._idx_chainrules[r.lhs()] == null) {
                    this._idx_chainrules[r.lhs()] = new Vector();
                }
                this._idx_chainrules[r.lhs()].add(r);
                if (this._idx_rev_chainrules[r.rhs()[0]] == null) {
                    this._idx_rev_chainrules[r.rhs()[0]] = new Vector();
                }
                this._idx_rev_chainrules[r.rhs()[0]].add(r);
                continue;
            }
            this._trules.add(r);
            if (this._idx_trules[r.lhs()] == null) {
                this._idx_trules[r.lhs()] = new Vector();
            }
            this._idx_trules[r.lhs()].add(r);
        }
        this.initChainVectors();
    }

    public void preterminalize() {
        int x = 1;
        HashMap<Integer, Integer> pts = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> ptc = new HashMap<Integer, Integer>();
        for (Rule r : this._rules) {
            if (r.rhs().length == 1) continue;
            int i = 0;
            while (i < r.rhs().length) {
                if (r.rhs()[i] < 0) {
                    if (pts.containsKey(r.rhs()[i])) {
                        ptc.put(r.rhs()[i], (Integer)ptc.get(r.rhs()[i]) + r.freq());
                        r.rhs()[i] = (Integer)pts.get(r.rhs()[i]);
                    } else {
                        int nt = this._nts.register("@T" + x);
                        ++x;
                        pts.put(r.rhs()[i], nt);
                        ptc.put(r.rhs()[i], r.freq());
                        r.rhs()[i] = nt;
                    }
                }
                ++i;
            }
        }
        Iterator<Rule> iterator = pts.keySet().iterator();
        while (iterator.hasNext()) {
            int t = (Integer)((Object)iterator.next());
            int[] rhs = new int[]{t};
            this._rules.add(new Rule((Integer)pts.get(t), rhs, (Integer)ptc.get(t)));
        }
    }

    public void binarize() {
        int x = 1;
        Vector<Rule> todo = this._rules;
        Vector<Rule> tmp = new Vector<Rule>();
        Vector<Rule> binarized = new Vector<Rule>();
        while (!todo.isEmpty()) {
            HashMap<String, Integer> paircounts = new HashMap<String, Integer>();
            int maxcount = -1;
            int maxA = -1;
            int maxB = -1;
            for (Rule r : todo) {
                if (r.arity() <= 2) {
                    binarized.add(r);
                    continue;
                }
                tmp.add(r);
                int previous = -1;
                int i = 0;
                while (i < r.arity() - 1) {
                    if (r.rhs()[i] == r.rhs()[i + 1] && r.rhs()[i] == previous) {
                        previous = -1;
                    } else {
                        String pair = String.valueOf(r.rhs()[i]) + ":" + r.rhs()[i + 1];
                        int c = paircounts.containsKey(pair) ? (Integer)paircounts.get(pair) : 0;
                        paircounts.put(pair, c + r.freq());
                        if (c + r.freq() > maxcount) {
                            maxcount = c + r.freq();
                            maxA = r.rhs()[i];
                            maxB = r.rhs()[i + 1];
                        }
                        previous = r.rhs()[i];
                    }
                    ++i;
                }
            }
            if (tmp.isEmpty()) break;
            todo.clear();
            int nt = this._nts.register("@B" + x);
            ++x;
            for (Rule r : tmp) {
                Vector<Integer> newrhs = new Vector<Integer>();
                boolean replaced = false;
                int i = 0;
                while (i < r.arity()) {
                    if (i < r.arity() - 1 && r.rhs()[i] == maxA && r.rhs()[i + 1] == maxB) {
                        replaced = true;
                        ++i;
                        newrhs.add(nt);
                    } else {
                        newrhs.add(r.rhs()[i]);
                    }
                    ++i;
                }
                if (!replaced) {
                    todo.add(r);
                    continue;
                }
                int[] nrhs = new int[newrhs.size()];
                int i2 = 0;
                while (i2 < newrhs.size()) {
                    nrhs[i2] = (Integer)newrhs.get(i2);
                    ++i2;
                }
                todo.add(new Rule(r.lhs(), nrhs, r.freq()));
            }
            binarized.add(new Rule(nt, new int[]{maxA, maxB}, maxcount));
            tmp.clear();
        }
        this._rules = binarized;
    }

    public void topoSort() {
        Vector[] ruleidx = new Vector[this._nts.size()];
        for (Rule r : this._rules) {
            if (ruleidx[r.lhs()] == null) {
                ruleidx[r.lhs()] = new Vector();
            }
            ruleidx[r.lhs()].add(r);
        }
        SymbolTable newnts = new SymbolTable();
        newnts.register(this._nts.lookup(this._start));
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(this._start);
        while (!q.isEmpty()) {
            int nt = (Integer)q.poll();
            for (Rule r : ruleidx[nt]) {
                int i = 0;
                while (i < r.arity()) {
                    if (r.rhs()[i] >= 0 && newnts.lookup(this._nts.lookup(r.rhs()[i])) == -1) {
                        newnts.register(this._nts.lookup(r.rhs()[i]));
                        q.add(r.rhs()[i]);
                    }
                    ++i;
                }
            }
        }
        String[] i = this._nts.symbols();
        int n = i.length;
        int r = 0;
        while (r < n) {
            String nt = i[r];
            if (newnts.lookup(nt) == -1) {
                newnts.register(nt);
            }
            ++r;
        }
        Vector<Rule> newrules = new Vector<Rule>();
        int nt = 0;
        while (nt < newnts.size()) {
            int oldnt = this._nts.lookup(newnts.lookup(nt));
            for (Rule r2 : ruleidx[oldnt]) {
                int[] newrhs = new int[r2.arity()];
                int i2 = 0;
                while (i2 < r2.arity()) {
                    newrhs[i2] = r2.rhs()[i2] >= 0 ? newnts.lookup(this._nts.lookup(r2.rhs()[i2])) : r2.rhs()[i2];
                    ++i2;
                }
                newrules.add(new Rule(nt, newrhs, r2.freq()));
            }
            ++nt;
        }
        this._nts = newnts;
        this._rules = newrules;
    }

    public void initChainVectors() {
        int _maxs = this._nts.size();
        this._chainvec = new BitSet[_maxs + 1];
        int i = 0;
        while (i <= _maxs) {
            this._chainvec[i] = new BitSet(_maxs + 1);
            this._chainvec[i].set(i);
            ++i;
        }
        for (Rule r : this.rules()) {
            if (r.arity() != 1 || r.rhs()[0] < 0) continue;
            this._chainvec[r.rhs()[0]].set(r.lhs());
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            int i2 = 0;
            while (i2 <= _maxs) {
                int j = 0;
                while (j <= _maxs) {
                    if (this._chainvec[i2].get(j)) {
                        int card = this._chainvec[i2].cardinality();
                        this._chainvec[i2].or(this._chainvec[j]);
                        if (card != this._chainvec[i2].cardinality()) {
                            changed = true;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
    }

    public BitSet[] chainvec() {
        return this._chainvec;
    }

    public void dumpGrammar(String filename) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(filename) + ".grammar"));
        for (Rule r : this._rules) {
            bw.write(String.valueOf(r.freq()) + " " + this.NT(r.lhs()));
            int[] nArray = r.rhs();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int x = nArray[n2];
                bw.write(" " + this.Symbol(x));
                ++n2;
            }
            bw.write("\n");
        }
        bw.close();
        this._l.dumpLexicon(filename);
    }

    public static void main(String[] args) {
        try {
            System.err.print("Loading ... ");
            Grammar g = null;
            if (args[0].endsWith(".gr")) {
                g = (Grammar)new ObjectInputStream(new FileInputStream(args[0])).readObject();
            } else {
                g = new Grammar();
                g.loadGrammar(args[0]);
            }
            System.err.println("done");
            g.analyzeConnectivity();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

