/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import LinguaView.syntax.CategoryObject;
import SyntaxUtils.CCGChart;
import fig.basic.LogInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ardverk.collection.PatriciaTrie;
import org.ardverk.collection.StringKeyAnalyzer;

public class CCGParseResult {
    List<CCGNode> nodes;
    public Set<Integer>[][] dependency;
    public boolean isDone = true;
    public String source;

    public boolean isDone() {
        return this.isDone;
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "#{nodes in stack}=" + this.nodes.size() + "\n";
        str = String.valueOf(str) + "Actions:\n";
        return str;
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        if (this.nodes.get((int)0).source != null) {
            String[] ss = this.nodes.get((int)0).source.split("\\s");
            sb.append("<br><h3>" + ss[0].substring(3) + "</h3>\n");
        }
        if (this.nodes.size() > 1) {
            sb.append("<pre>Fail to complete this sentence</pre>");
        } else {
            sb.append("<pre>" + this.nodes.get(0).toIndentedTreeString() + "</pre>\n");
        }
        ArrayList<CCGTerminalNode> terms = new ArrayList<CCGTerminalNode>();
        for (CCGNode result : this.nodes) {
            terms.addAll(result.collectTerminalNodes());
        }
        sb.append("<table cellpadding=\"10\">\n");
        int i = 0;
        while (i < this.dependency.length) {
            Object[] colors = new Object[]{"<font color=\"firebrick\">", "</font>", "<font color=\"mediumblue\">", "</font>", "<font color=\"green\">", "</font>", "<font color=\"orchid\">", "</font>", "<font color=\"mediumblue\">", "</font>", "<font color=\"green\">", "</font>", "<font color=\"orchid\">", "</font>"};
            sb.append("<tr>\n");
            sb.append("<td>");
            sb.append(i + 1);
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(String.format("<b>%s</b>\n", ((CCGTerminalNode)terms.get(i)).word()));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(String.format("<i>%s</i>\n", ((CCGTerminalNode)terms.get(i)).category().toColoredString()));
            sb.append("</td>\n");
            int j = 0;
            while (j < this.dependency[i].length) {
                sb.append("<td>");
                if (this.dependency[i][j] == null) {
                    sb.append(String.format("<font color=\"FF0000\"><b>%s</b></font>", "null"));
                } else {
                    int z2;
                    sb.append(String.format("<font color=\"%s\">", CategoryObject.HTMLColors[j % 4]));
                    ArrayList<String> heads = new ArrayList<String>();
                    for (int z2 : this.dependency[i][j]) {
                        heads.add(((CCGTerminalNode)terms.get(z2)).word());
                    }
                    sb.append((String)heads.get(0));
                    z2 = 1;
                    while (z2 < heads.size()) {
                        sb.append(", " + (String)heads.get(z2));
                        ++z2;
                    }
                    sb.append("</font>");
                }
                sb.append("</td>\n");
                ++j;
            }
            sb.append("</tr>\n");
            ++i;
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static void loadMarkup(BufferedReader br) throws IOException {
        ArrayList<String> plainCache = new ArrayList<String>();
        ArrayList<String> indexedCache = new ArrayList<String>();
        String s = br.readLine();
        int state = 0;
        String plainCat = null;
        String indexedCat = null;
        int line = 0;
        while (s != null) {
            if (s.equals("EOP")) break;
            ++line;
            if ((s = s.trim()).length() == 0) {
                if (state == 1) {
                    LogInfo.warning("Wrong Format at line" + line);
                } else if (state > 0) {
                    plainCache.add(plainCat);
                    indexedCache.add(indexedCat);
                }
                state = 0;
            } else if ((s = s.replaceAll("#.*$", "").trim()).length() != 0) {
                switch (state) {
                    case 0: {
                        plainCat = s;
                        state = 1;
                        break;
                    }
                    case 1: {
                        indexedCat = s;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (s.charAt(0) == '!') {
                            char c = indexedCat.charAt(0);
                            s.replace('!', c);
                            break;
                        }
                    }
                    case 3: {
                        state = 3;
                    }
                }
            }
            s = br.readLine();
        }
        if (state == 1) {
            LogInfo.warning("Incomplete File");
        } else if (state > 0) {
            plainCache.add(plainCat);
            indexedCache.add(indexedCat);
        }
        PatriciaTrie<String, String> _cache = new PatriciaTrie<String, String>(StringKeyAnalyzer.CHAR);
        int i = 0;
        while (i < plainCache.size()) {
            String pcat = (String)plainCache.get(i);
            _cache.put((Object)pcat.replace('(', '{').replace(')', '}'), (Object)((String)indexedCache.get(i)));
            ++i;
        }
        CCGTerminalNode.setInterpret(_cache);
    }

    public static void main(String[] args) throws IOException {
        if (args.length <= 2) {
            System.out.println("Usuage: <MarkedUp-file> <CCGBank-file> <output-file>");
            System.exit(-1);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
        CCGParseResult.loadMarkup(br);
        br.close();
        ArrayList<CCGNode> cn = CCGNode.readCCGFile(new File(args[1]), "UTF-8");
        PrintWriter pw = new PrintWriter(args[2], "GBK");
        pw.println("<html><body>");
        pw.println("This file is generated by edu.pku.coli.pear.ccg.ParseResult.");
        for (CCGNode c : cn) {
            CCGParseResult pr = CCGChart.goldParse(c);
            pw.println(pr.toHTML());
            pw.println();
        }
        pw.println("</body></html>");
        pw.close();
    }
}

