/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import SyntaxUtils.CCGBinaryRule;
import SyntaxUtils.CCGRule;
import SyntaxUtils.CCGUnaryRule;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CCGGrammar {
    public Map<String, Set<CCGBinaryRule>> binaryRuleMap = new HashMap<String, Set<CCGBinaryRule>>();
    public Map<String, Set<CCGUnaryRule>> unaryRuleMap = new HashMap<String, Set<CCGUnaryRule>>();

    private CCGGrammar() {
    }

    public static CCGGrammar createNewGrammar() {
        return new CCGGrammar();
    }

    public Set<CCGBinaryRule> lookup(String left, String right) {
        return this.binaryRuleMap.get(String.valueOf(left) + "+" + right);
    }

    public Set<CCGUnaryRule> lookup(String unaryCat) {
        return this.unaryRuleMap.get(unaryCat);
    }

    public void remove(CCGRule r) {
        if (r instanceof CCGBinaryRule) {
            this.binaryRuleMap.remove(r.key());
        } else if (r instanceof CCGUnaryRule) {
            this.unaryRuleMap.remove(r.key());
        }
    }

    public void increSeenCount(String child, String res) {
        this.increSeenCount(child, res, 1);
    }

    public void increSeenCount(String child, String res, int freq) {
        Set<CCGUnaryRule> rules = this.lookup(child);
        if (rules != null) {
            boolean find = false;
            for (CCGUnaryRule r : rules) {
                if (!r.result.equals(res)) continue;
                r.increSeenCount(freq);
                find = true;
            }
            if (!find) {
                rules.add(new CCGUnaryRule(child, res, freq));
            }
        } else {
            rules = new TreeSet<CCGRule>(CCGRule.freqComparator);
            CCGUnaryRule ur = new CCGUnaryRule(child, res, freq);
            rules.add(ur);
            this.unaryRuleMap.put(child, rules);
        }
    }

    public void increSeenCount(String left, String right, String result, int head) {
        this.increSeenCount(left, right, result, head, 1);
    }

    public void increSeenCount(String left, String right, String result, int head, int freq) {
        Set<CCGBinaryRule> rules = this.lookup(left, right);
        if (rules != null) {
            boolean find = false;
            for (CCGBinaryRule r : rules) {
                if (!r.result.equals(result) || r.headChild != head) continue;
                r.increSeenCount(freq);
                find = true;
            }
            if (!find) {
                rules.add(new CCGBinaryRule(left, right, result, head, freq));
            }
        } else {
            rules = new TreeSet<CCGRule>(CCGRule.freqComparator);
            CCGBinaryRule br = new CCGBinaryRule(left, right, result, head, freq);
            rules.add(br);
            this.binaryRuleMap.put(br.key(), rules);
        }
    }

    public void load(BufferedReader rs) throws IOException {
        Set<CCGRule> rules;
        String s = rs.readLine();
        while (s != null && s.trim().length() > 0) {
            CCGBinaryRule bRule = new CCGBinaryRule(s.trim());
            rules = this.binaryRuleMap.get(bRule.key());
            if (rules == null) {
                rules = new TreeSet<CCGRule>(CCGRule.freqComparator);
            }
            rules.add(bRule);
            this.binaryRuleMap.put(bRule.key(), rules);
            s = rs.readLine();
        }
        s = rs.readLine();
        while (s != null && s.trim().length() > 0) {
            CCGUnaryRule uRule = new CCGUnaryRule(s.trim());
            rules = this.unaryRuleMap.get(uRule.left);
            if (rules == null) {
                rules = new TreeSet<CCGRule>(CCGRule.freqComparator);
            }
            rules.add((CCGBinaryRule)((Object)uRule));
            this.unaryRuleMap.put(uRule.left, rules);
            s = rs.readLine();
        }
    }

    public static CCGGrammar loadFromStream(BufferedReader rs) throws IOException {
        CCGGrammar gr = new CCGGrammar();
        gr.load(rs);
        return gr;
    }

    public static CCGGrammar loadFromFile(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
        return CCGGrammar.loadFromStream(br);
    }

    public void dump(Writer w) throws IOException {
        for (Set<CCGBinaryRule> set : this.binaryRuleMap.values()) {
            for (CCGBinaryRule cCGBinaryRule : set) {
                w.write(cCGBinaryRule + "\n");
            }
        }
        w.write("\n");
        for (Set<CCGRule> set : this.unaryRuleMap.values()) {
            for (CCGUnaryRule cCGUnaryRule : set) {
                w.write(cCGUnaryRule + "\n");
            }
        }
        w.write("\n");
    }
}

