/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class PImage
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_IMAGE = "image";
    public static final int PROPERTY_CODE_IMAGE = 32768;
    private transient Image image;

    public PImage() {
    }

    public PImage(String string) {
        this(Toolkit.getDefaultToolkit().getImage(string));
    }

    public PImage(Image image) {
        this.setImage(image);
    }

    public PImage(URL uRL) {
        if (uRL != null) {
            this.setImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(string));
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        this.image = image == null || image instanceof BufferedImage ? image : this.getLoadedImage(image);
        if (this.image != null) {
            this.setBounds(0.0, 0.0, this.getImage().getWidth(null), this.getImage().getHeight(null));
            this.invalidatePaint();
        }
        this.firePropertyChange(32768, PROPERTY_IMAGE, image2, this.image);
    }

    private Image getLoadedImage(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        switch (imageIcon.getImageLoadStatus()) {
            case 1: 
            case 8: {
                return imageIcon.getImage();
            }
        }
        return null;
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this.getImage() == null) {
            return;
        }
        double d = this.image.getWidth(null);
        double d2 = this.image.getHeight(null);
        PBounds pBounds = this.getBoundsReference();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (pBounds.x != 0.0 || pBounds.y != 0.0 || pBounds.width != d || pBounds.height != d2) {
            graphics2D.translate(pBounds.x, pBounds.y);
            graphics2D.scale(pBounds.width / d, pBounds.height / d2);
            graphics2D.drawImage(this.image, 0, 0, null);
            graphics2D.scale(d / pBounds.width, d2 / pBounds.height);
            graphics2D.translate(-pBounds.x, -pBounds.y);
        } else {
            graphics2D.drawImage(this.image, 0, 0, null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        BufferedImage bufferedImage = PImage.toBufferedImage(this.image, false);
        if (bufferedImage != null) {
            ImageIO.write((RenderedImage)bufferedImage, "png", objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.image = ImageIO.read(objectInputStream);
    }

    public static BufferedImage toBufferedImage(Image image, boolean bl) {
        Object object;
        BufferedImage bufferedImage;
        if (image == null) {
            return null;
        }
        if (!bl && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (GraphicsEnvironment.isHeadless()) {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            bufferedImage = ((GraphicsConfiguration)object).createCompatibleImage(image.getWidth(null), image.getHeight(null));
        }
        object = bufferedImage.createGraphics();
        ((Graphics)object).drawImage(image, 0, 0, null);
        ((Graphics)object).dispose();
        return bufferedImage;
    }
}

