/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.content.eqclasses.properties.lshcontext.LSHContext;
import babel.content.eqclasses.properties.lshtime.LSHTimeDistribution;
import babel.ranking.scorers.context.FungS1Scorer;
import babel.ranking.scorers.lsh.LSHScorer;
import babel.ranking.scorers.timedistribution.TimeDistributionCosineScorer;
import babel.reordering.scorers.LSHMonoScorer;
import babel.reordering.scorers.MonoScorer;
import babel.util.config.Configurator;
import babel.util.dict.SimpleDictionary;
import java.util.HashSet;
import java.util.Set;
import main.phrases.FeatureEstimator;
import main.phrases.OrderEstimator;
import main.phrases.PhrasePreparer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhraseScorer {
    protected static final Log LOG = LogFactory.getLog(PhraseScorer.class);
    protected static PhraseTable.PairFeat[] FEATS_BPL = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.FE, PhraseTable.PairFeat.LEX_FE, PhraseTable.PairFeat.EF, PhraseTable.PairFeat.LEX_EF, PhraseTable.PairFeat.PHPENALTY, PhraseTable.PairFeat.PH_CONTEXT, PhraseTable.PairFeat.PH_TIME, PhraseTable.PairFeat.LEX_CONTEXT, PhraseTable.PairFeat.LEX_TIME, PhraseTable.PairFeat.LEX_EDIT};
    protected static PhraseTable.PairFeat[] FEATS_PL = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.PHPENALTY, PhraseTable.PairFeat.PH_CONTEXT, PhraseTable.PairFeat.PH_TIME, PhraseTable.PairFeat.LEX_CONTEXT, PhraseTable.PairFeat.LEX_TIME, PhraseTable.PairFeat.LEX_EDIT};
    protected static PhraseTable.PairFeat[] FEATS_P = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.PHPENALTY, PhraseTable.PairFeat.PH_CONTEXT, PhraseTable.PairFeat.PH_TIME};
    protected static PhraseTable.PairFeat[] FEATS_L = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.PHPENALTY, PhraseTable.PairFeat.LEX_CONTEXT, PhraseTable.PairFeat.LEX_TIME, PhraseTable.PairFeat.LEX_EDIT};
    protected static PhraseTable.PairFeat[] FEATS_NONE = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.PHPENALTY};

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("\n" + Configurator.getConfigDescriptor()));
        boolean doMonoFeatures = Configurator.CONFIG.getBoolean("preprocessing.phrases.features.DoMonoFeatures");
        boolean doReordering = Configurator.CONFIG.getBoolean("preprocessing.phrases.reordering.DoReordering");
        PhraseScorer scorer = new PhraseScorer();
        if (doMonoFeatures && doReordering) {
            LOG.info((Object)"===> Estimating both monolingual and reordering features <===");
            scorer.scorePhraseFeaturesAndOrder();
        } else if (doMonoFeatures) {
            LOG.info((Object)"===> Estimating  monolingual features only <===");
            scorer.scorePhraseFeaturesOnly();
        } else if (doReordering) {
            LOG.info((Object)"===> Estimating reordering features only <===");
            scorer.scorePhraseOrderOnly();
        } else {
            LOG.warn((Object)"===> NOT estimating either monolingual or reordering features <===");
        }
        LOG.info((Object)"===> Done <===");
    }

    protected void scorePhraseOrderOnly() throws Exception {
        Set<Phrase> chunk;
        String outDir = Configurator.CONFIG.getString("output.Path");
        String outReorderingTableM = Configurator.CONFIG.getString("output.ReorderingTableM");
        int numReorderingThreads = Configurator.CONFIG.getInt("preprocessing.phrases.reordering.ReorderingThreads");
        int chunkSize = Configurator.CONFIG.containsKey("preprocessing.phrases.ChunkSize") && Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") > 0 ? Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") : Integer.MAX_VALUE;
        boolean approxOrder = Configurator.CONFIG.getBoolean("preprocessing.phrases.reordering.ApproxReordWithLSH");
        LOG.info((Object)("--- Preparing for estimating reordering features " + (chunkSize != Integer.MAX_VALUE ? "in chunks of size " + chunkSize : "") + " ---"));
        PhrasePreparer preparer = new PhrasePreparer();
        preparer.prepareForChunkOrderCollection();
        PhraseTable phraseTable = preparer.getPhraseTable();
        int chunkNum = 0;
        OrderEstimator orderEstimator = approxOrder ? new OrderEstimator(numReorderingThreads, new LSHMonoScorer(), phraseTable, preparer.getMaxTrgPhrCount()) : new OrderEstimator(numReorderingThreads, new MonoScorer(phraseTable), phraseTable, preparer.getMaxTrgPhrCount());
        while ((chunk = preparer.getNextChunk(chunkSize)) != null) {
            LOG.info((Object)(" - Preparing chunk " + chunkNum++ + " of phrase table ..."));
            Set<Phrase> trgChunk = phraseTable.getTrgPhrases(chunk);
            preparer.collectPropsForOrderOnly(chunk, trgChunk);
            preparer.pruneMostFrequentContext(true, chunk);
            preparer.pruneMostFrequentContext(false, trgChunk);
            preparer.prepareOrderProps(true, chunk, approxOrder);
            preparer.prepareOrderProps(false, trgChunk, approxOrder);
            LOG.info((Object)(" - Estimating reordering features for phrase table chunk " + (chunkNum - 1) + "..."));
            orderEstimator.estimateReordering(chunk);
            phraseTable.saveReorderingTableChunk(chunk, String.valueOf(outDir) + "/" + outReorderingTableM);
            preparer.clearReorderingFeatures(chunk);
            preparer.clearReorderingFeatures(phraseTable.getTrgPhrases(chunk));
        }
    }

    protected void scorePhraseFeaturesOnly() throws Exception {
        Set<Phrase> chunk;
        boolean wikiok;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        String outDir = Configurator.CONFIG.getString("output.Path");
        int numMonoScoringThreads = Configurator.CONFIG.getInt("preprocessing.phrases.features.MonoScoringThreads");
        int chunkSize = Configurator.CONFIG.containsKey("preprocessing.phrases.ChunkSize") && Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") > 0 ? Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") : Integer.MAX_VALUE;
        String outPhraseTableBPL = Configurator.CONFIG.getString("output.PhraseTableBPL");
        String outPhraseTablePL = Configurator.CONFIG.getString("output.PhraseTablePL");
        String outPhraseTableP = Configurator.CONFIG.getString("output.PhraseTableP");
        String outPhraseTableL = Configurator.CONFIG.getString("output.PhraseTableL");
        String outPhraseTableNone = Configurator.CONFIG.getString("output.PhraseTableNone");
        boolean collectPhraseFeats = outPhraseTableBPL != null || outPhraseTablePL != null || outPhraseTableP != null;
        boolean collectLexFeats = outPhraseTableBPL != null || outPhraseTablePL != null || outPhraseTableL != null;
        boolean approxFeats = Configurator.CONFIG.getBoolean("preprocessing.phrases.features.ApproxFeatsWithLSH");
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && windowSize != 1) {
            windowSize = 1;
            LOG.info((Object)"WARNING: Using Wikipedia 'temporal' estimates, set time window to size 1 ");
        }
        if (outPhraseTableBPL != null) {
            outPhraseTableBPL = String.valueOf(outDir) + "/" + outPhraseTableBPL;
        }
        if (outPhraseTablePL != null) {
            outPhraseTablePL = String.valueOf(outDir) + "/" + outPhraseTablePL;
        }
        if (outPhraseTableP != null) {
            outPhraseTableP = String.valueOf(outDir) + "/" + outPhraseTableP;
        }
        if (outPhraseTableL != null) {
            outPhraseTableL = String.valueOf(outDir) + "/" + outPhraseTableL;
        }
        if (outPhraseTableNone != null) {
            outPhraseTableNone = String.valueOf(outDir) + "/" + outPhraseTableNone;
        }
        LOG.info((Object)("--- Preparing for estimating monolingual features " + (chunkSize != Integer.MAX_VALUE ? "in chunks of size " + chunkSize : "") + " ---"));
        PhrasePreparer preparer = new PhrasePreparer();
        preparer.prepareForChunkFeaturesCollection();
        PhraseTable phraseTable = preparer.getPhraseTable();
        int chunkNum = 0;
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && !(wikiok = preparer.checkWikiTemp())) {
            throw new Exception("Wikipedia files must match for 'temporal' scoring");
        }
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        SimpleDictionary translitDict = preparer.getTranslitDict();
        Set<Phrase> singleTokenSrcPhrases = phraseTable.getAllSingleTokenSrcPhrases();
        Set<Phrase> singleTokenTrgPhrases = phraseTable.getAllSingleTokenTrgPhrases();
        FeatureEstimator featEstimator = approxFeats ? new FeatureEstimator(phraseTable, singleTokenSrcPhrases, singleTokenTrgPhrases, numMonoScoringThreads, new LSHScorer(LSHContext.class), new LSHScorer(LSHTimeDistribution.class), translitDict, collectPhraseFeats, collectLexFeats) : new FeatureEstimator(phraseTable, singleTokenSrcPhrases, singleTokenTrgPhrases, numMonoScoringThreads, contextScorer, timeScorer, translitDict, collectPhraseFeats, collectLexFeats);
        preparer.collectPropsForFeaturesOnly(singleTokenSrcPhrases, singleTokenTrgPhrases);
        preparer.prepareContextAndTimeProps(true, singleTokenSrcPhrases, contextScorer, timeScorer, approxFeats);
        preparer.prepareContextAndTimeProps(false, singleTokenTrgPhrases, contextScorer, timeScorer, approxFeats);
        while ((chunk = preparer.getNextChunk(chunkSize)) != null) {
            LOG.info((Object)(" - Preparing chunk " + chunkNum++ + " of phrase table ..."));
            HashSet<Phrase> srcChunkToProcess = new HashSet<Phrase>(chunk);
            srcChunkToProcess.removeAll(singleTokenSrcPhrases);
            HashSet<Phrase> trgChunkToProcess = new HashSet<Phrase>(phraseTable.getTrgPhrases(chunk));
            trgChunkToProcess.removeAll(singleTokenTrgPhrases);
            preparer.collectPropsForFeaturesOnly(srcChunkToProcess, trgChunkToProcess);
            preparer.prepareContextAndTimeProps(true, srcChunkToProcess, contextScorer, timeScorer, approxFeats);
            preparer.prepareContextAndTimeProps(false, trgChunkToProcess, contextScorer, timeScorer, approxFeats);
            LOG.info((Object)(" - Estimating monolingual features for phrase table chunk " + (chunkNum - 1) + "..."));
            featEstimator.estimateFeatures(chunk);
            phraseTable.savePhraseTableChunk(chunk, outPhraseTableBPL, FEATS_BPL);
            phraseTable.savePhraseTableChunk(chunk, outPhraseTablePL, FEATS_PL);
            phraseTable.savePhraseTableChunk(chunk, outPhraseTableP, FEATS_P);
            phraseTable.savePhraseTableChunk(chunk, outPhraseTableL, FEATS_L);
            phraseTable.savePhraseTableChunk(chunk, outPhraseTableNone, FEATS_NONE);
            preparer.clearPhraseTableFeatures(srcChunkToProcess);
            preparer.clearPhraseTableFeatures(trgChunkToProcess);
        }
    }

    protected void scorePhraseFeaturesOnlyForAnni() throws Exception {
        boolean wikiok;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        String outDir = Configurator.CONFIG.getString("output.Path");
        int numMonoScoringThreads = Configurator.CONFIG.getInt("preprocessing.phrases.features.MonoScoringThreads");
        int chunkSize = Configurator.CONFIG.containsKey("preprocessing.phrases.ChunkSize") && Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") > 0 ? Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") : Integer.MAX_VALUE;
        String outPhraseTablePL = Configurator.CONFIG.getString("output.PhraseTablePL");
        String outPhraseTableP = Configurator.CONFIG.getString("output.PhraseTableP");
        String outPhraseTableL = Configurator.CONFIG.getString("output.PhraseTableL");
        boolean collectPhraseFeats = outPhraseTablePL != null || outPhraseTableP != null;
        boolean collectLexFeats = outPhraseTablePL != null || outPhraseTableL != null;
        boolean approxFeats = Configurator.CONFIG.getBoolean("preprocessing.phrases.features.ApproxFeatsWithLSH");
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && windowSize != 1) {
            windowSize = 1;
            LOG.info((Object)"WARNING: Using Wikipedia 'temporal' estimates, set time window to size 1 ");
        }
        if (outPhraseTablePL != null) {
            outPhraseTablePL = String.valueOf(outDir) + "/" + outPhraseTablePL;
        }
        if (outPhraseTableP != null) {
            outPhraseTableP = String.valueOf(outDir) + "/" + outPhraseTableP;
        }
        if (outPhraseTableL != null) {
            outPhraseTableL = String.valueOf(outDir) + "/" + outPhraseTableL;
        }
        LOG.info((Object)("--- Preparing for estimating monolingual features " + (chunkSize != Integer.MAX_VALUE ? "in chunks of size " + chunkSize : "") + " ---"));
        PhrasePreparer preparer = new PhrasePreparer();
        preparer.prepareForChunkFeaturesCollectionForAnni(chunkSize);
        int chunkNum = 0;
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && !(wikiok = preparer.checkWikiTemp())) {
            throw new Exception("Wikipedia files must match for 'temporal' scoring");
        }
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        SimpleDictionary translitDict = preparer.getTranslitDict();
        while (preparer.readNextChunkForAnni(chunkSize, chunkNum++) > 0) {
            Set<Phrase> srcChunkToProcess = preparer.getPhraseTable().getAllSrcPhrases();
            Set<Phrase> trgChunkToProcess = preparer.getPhraseTable().getAllTrgPhrases();
            preparer.collectPropsForFeaturesOnly(srcChunkToProcess, trgChunkToProcess);
            preparer.prepareContextAndTimeProps(true, srcChunkToProcess, contextScorer, timeScorer, approxFeats);
            preparer.prepareContextAndTimeProps(false, trgChunkToProcess, contextScorer, timeScorer, approxFeats);
            LOG.info((Object)(" - Estimating monolingual features for phrase table chunk " + (chunkNum - 1) + "..."));
            if (approxFeats) {
                new FeatureEstimator(preparer.getPhraseTable(), numMonoScoringThreads, new LSHScorer(LSHContext.class), new LSHScorer(LSHTimeDistribution.class), translitDict, collectPhraseFeats, collectLexFeats).estimateFeatures(srcChunkToProcess);
            } else {
                new FeatureEstimator(preparer.getPhraseTable(), numMonoScoringThreads, contextScorer, timeScorer, translitDict, collectPhraseFeats, collectLexFeats).estimateFeatures(srcChunkToProcess);
            }
            preparer.getPhraseTable().savePhraseTableChunk(srcChunkToProcess, outPhraseTablePL, FEATS_PL);
            preparer.getPhraseTable().savePhraseTableChunk(srcChunkToProcess, outPhraseTableP, FEATS_P);
            preparer.getPhraseTable().savePhraseTableChunk(srcChunkToProcess, outPhraseTableL, FEATS_L);
        }
    }

    protected void scorePhraseFeaturesAndOrder() throws Exception {
        boolean wikiok;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        String outDir = Configurator.CONFIG.getString("output.Path");
        String outReorderingTableM = Configurator.CONFIG.getString("output.ReorderingTableM");
        int numReorderingThreads = Configurator.CONFIG.getInt("preprocessing.phrases.reordering.ReorderingThreads");
        int numMonoScoringThreads = Configurator.CONFIG.getInt("preprocessing.phrases.features.MonoScoringThreads");
        String outPhraseTableBPL = Configurator.CONFIG.getString("output.PhraseTableBPL");
        String outPhraseTablePL = Configurator.CONFIG.getString("output.PhraseTablePL");
        String outPhraseTableP = Configurator.CONFIG.getString("output.PhraseTableP");
        String outPhraseTableL = Configurator.CONFIG.getString("output.PhraseTableL");
        String outPhraseTableNone = Configurator.CONFIG.getString("output.PhraseTableNone");
        boolean collectPhraseFeats = outPhraseTableBPL != null || outPhraseTablePL != null || outPhraseTableP != null;
        boolean collectLexFeats = outPhraseTableBPL != null || outPhraseTablePL != null || outPhraseTableL != null;
        boolean approxFeats = Configurator.CONFIG.getBoolean("preprocessing.phrases.features.ApproxFeatsWithLSH");
        boolean approxOrder = Configurator.CONFIG.getBoolean("preprocessing.phrases.reordering.ApproxReordWithLSH");
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && windowSize != 1) {
            windowSize = 1;
            LOG.info((Object)"WARNING: Using Wikipedia 'temporal' estimates, set time window to size 1 ");
        }
        if (outPhraseTableBPL != null) {
            outPhraseTableBPL = String.valueOf(outDir) + "/" + outPhraseTableBPL;
        }
        if (outPhraseTablePL != null) {
            outPhraseTablePL = String.valueOf(outDir) + "/" + outPhraseTablePL;
        }
        if (outPhraseTableP != null) {
            outPhraseTableP = String.valueOf(outDir) + "/" + outPhraseTableP;
        }
        if (outPhraseTableL != null) {
            outPhraseTableL = String.valueOf(outDir) + "/" + outPhraseTableL;
        }
        if (outPhraseTableNone != null) {
            outPhraseTableNone = String.valueOf(outDir) + "/" + outPhraseTableNone;
        }
        PhrasePreparer preparer = new PhrasePreparer();
        preparer.prepareForFeaturesAndOrderCollection();
        if ("wikitemp".equals(Configurator.CONFIG.getString("preprocessing.input.Time")) && !(wikiok = preparer.checkWikiTemp())) {
            throw new Exception("Wikipedia files must match for 'temporal' scoring");
        }
        PhraseTable phraseTable = preparer.getPhraseTable();
        Set<Phrase> srcPhrases = phraseTable.getAllSrcPhrases();
        Set<Phrase> trgPhrases = phraseTable.getAllTrgPhrases();
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        SimpleDictionary translitDict = preparer.getTranslitDict();
        LOG.info((Object)"--- Estimating monolingual features ---");
        preparer.prepareContextAndTimeProps(true, srcPhrases, contextScorer, timeScorer, approxFeats);
        preparer.prepareContextAndTimeProps(false, trgPhrases, contextScorer, timeScorer, approxFeats);
        if (approxFeats) {
            new FeatureEstimator(phraseTable, numMonoScoringThreads, new LSHScorer(LSHContext.class), new LSHScorer(LSHTimeDistribution.class), translitDict, collectPhraseFeats, collectLexFeats).estimateFeatures(srcPhrases);
        } else {
            new FeatureEstimator(phraseTable, numMonoScoringThreads, contextScorer, timeScorer, translitDict, collectPhraseFeats, collectLexFeats).estimateFeatures(srcPhrases);
        }
        phraseTable.savePhraseTable(outPhraseTableBPL, FEATS_BPL);
        phraseTable.savePhraseTable(outPhraseTablePL, FEATS_PL);
        phraseTable.savePhraseTable(outPhraseTableP, FEATS_P);
        phraseTable.savePhraseTable(outPhraseTableL, FEATS_L);
        phraseTable.savePhraseTable(outPhraseTableNone, FEATS_NONE);
        LOG.info((Object)"--- Estimating reordering features ---");
        preparer.pruneMostFrequentContext(true, srcPhrases);
        preparer.pruneMostFrequentContext(false, trgPhrases);
        preparer.prepareOrderProps(true, srcPhrases, approxOrder);
        preparer.prepareOrderProps(false, trgPhrases, approxOrder);
        if (approxOrder) {
            new OrderEstimator(numReorderingThreads, new LSHMonoScorer(), phraseTable, preparer.getMaxTrgPhrCount()).estimateReordering(srcPhrases);
        } else {
            new OrderEstimator(numReorderingThreads, new MonoScorer(phraseTable), phraseTable, preparer.getMaxTrgPhrCount()).estimateReordering(srcPhrases);
        }
        phraseTable.saveReorderingTable(String.valueOf(outDir) + "/" + outReorderingTableM);
    }
}

