/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhrasePair;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.reordering.scorers.ReorderingScorer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderEstimator {
    protected static final Log LOG = LogFactory.getLog(OrderEstimator.class);
    protected static final int NUM_PAIRS_TO_GIVE = 10000;
    protected static final int PERCENT_REPORT = 5;
    protected int m_numThreads;
    protected ReorderingScorer m_reordScorer;
    protected PhraseTable m_phraseTable;
    protected List<Integer> m_workerIds;
    protected LinkedList<PhrasePair> m_phrasePairsToProcess;
    protected int m_percentComplete;
    protected int m_percentThreshold;
    protected double m_completePairs;
    protected double m_totalPairs;
    protected double m_maxPhrCountInTrg;

    public OrderEstimator(int numThreads, ReorderingScorer reordScorer, PhraseTable phraseTable, double maxPhrCountInTrg) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must request at least one thread");
        }
        this.m_numThreads = numThreads;
        this.m_reordScorer = reordScorer;
        this.m_maxPhrCountInTrg = maxPhrCountInTrg;
        this.m_phraseTable = phraseTable;
        this.m_workerIds = new ArrayList<Integer>(this.m_numThreads);
        this.m_phrasePairsToProcess = new LinkedList();
    }

    public synchronized void estimateReordering(Set<Phrase> srcPhrases) throws Exception {
        this.m_workerIds.clear();
        this.m_percentComplete = 0;
        this.m_completePairs = 0.0;
        this.m_percentThreshold = 5;
        this.m_phrasePairsToProcess.clear();
        LOG.info((Object)" - Selecting phrase pairs with reordering property ...");
        for (Phrase srcPhrase : srcPhrases) {
            for (Phrase trgPhrase : this.m_phraseTable.getTrgPhrases(srcPhrase)) {
                this.m_phrasePairsToProcess.add(new PhrasePair(srcPhrase, trgPhrase));
            }
        }
        this.m_totalPairs = this.m_phrasePairsToProcess.size();
        LOG.info((Object)(" - Estimating reordering for " + (int)this.m_totalPairs + " phrases with contextual phrases found in monolingual data ..."));
        int threadNum = 0;
        while (threadNum < this.m_numThreads) {
            this.m_workerIds.add(threadNum);
            new Thread(new OrderWorker(this, threadNum)).start();
            ++threadNum;
        }
        while (this.m_workerIds.size() > 0) {
            this.wait();
        }
    }

    protected synchronized List<PhrasePair> getPhrasePairsToProcess() {
        ArrayList<PhrasePair> pairsToProcess = null;
        if (this.m_phrasePairsToProcess.size() > 0) {
            pairsToProcess = new ArrayList<PhrasePair>(10000);
            int i = 0;
            while (this.m_phrasePairsToProcess.size() > 0 && i < 10000) {
                pairsToProcess.add(this.m_phrasePairsToProcess.remove());
                ++i;
            }
        }
        return pairsToProcess;
    }

    protected synchronized void estimationDone(int numComplete) {
        this.m_completePairs += (double)numComplete;
        this.m_percentComplete = (int)(100.0 * this.m_completePairs / this.m_totalPairs);
        if (this.m_percentComplete >= this.m_percentThreshold) {
            LOG.info((Object)(" - " + this.m_percentComplete + "% done."));
            this.m_percentThreshold += 5;
        }
    }

    protected synchronized void workerDone(int workerID) {
        this.m_workerIds.remove(new Integer(workerID));
        this.notify();
    }

    protected void estimateReordering(Phrase srcPhrase, Phrase trgPhrase) {
        ReorderingScorer.OrderTriple beforeFeats = this.m_reordScorer.scoreBefore(srcPhrase, trgPhrase);
        ReorderingScorer.OrderTriple afterFeats = this.m_reordScorer.scoreAfter(srcPhrase, trgPhrase);
        PhraseTable.PairProps props = this.m_phraseTable.getProps(srcPhrase, trgPhrase);
        if (beforeFeats != null) {
            props.setBeforeOrderFeatVals(beforeFeats.getMonoScore(), beforeFeats.getSwapScore(), beforeFeats.getDiscScore());
        }
        if (afterFeats != null) {
            props.setAfterOrderFeatVals(afterFeats.getMonoScore(), afterFeats.getSwapScore(), afterFeats.getDiscScore());
        }
    }

    class OrderWorker
    implements Runnable {
        protected int m_workerId;
        protected OrderEstimator m_estimator;

        public OrderWorker(OrderEstimator estimator, int workerId) {
            this.m_workerId = workerId;
            this.m_estimator = estimator;
        }

        @Override
        public void run() {
            List<PhrasePair> phrasePairs;
            LOG.info((Object)(" - Worker " + this.m_workerId + " started estimating reordering features."));
            while ((phrasePairs = this.m_estimator.getPhrasePairsToProcess()) != null) {
                for (PhrasePair pair : phrasePairs) {
                    this.m_estimator.estimateReordering(pair.srcPhrase(), pair.trgPhrase());
                }
                this.m_estimator.estimationDone(phrasePairs.size());
            }
            LOG.info((Object)(" - Worker " + this.m_workerId + " finished."));
            this.m_estimator.workerDone(this.m_workerId);
        }
    }
}

