/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.edit;

import babel.content.eqclasses.EquivalenceClass;
import babel.ranking.scorers.Scorer;
import babel.util.misc.EditDistance;

public class EditDistanceScorer
extends Scorer {
    @Override
    public double score(EquivalenceClass oneEq, EquivalenceClass twoEq) {
        double count = 0.0;
        double dist = 0.0;
        for (String oneStr : oneEq.getAllWords()) {
            for (String twoStr : twoEq.getAllWords()) {
                dist += (double)EditDistance.distance(oneStr, twoStr);
                count += 1.0;
            }
        }
        return dist / count;
    }

    @Override
    public boolean smallerScoresAreBetter() {
        return true;
    }

    @Override
    public void prepare(EquivalenceClass eq) {
    }
}

