/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.time;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.corpora.accessors.TemporalCorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.PhrasePropertyCollector;
import babel.content.eqclasses.properties.time.TimeDistribution;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhraseTimeDistributionCollector
extends PhrasePropertyCollector {
    protected static final Log LOG = LogFactory.getLog(PhraseTimeDistributionCollector.class);
    protected HashSet<Integer> m_binIdxs = new HashSet();

    public PhraseTimeDistributionCollector(int maxPhraseLength, boolean caseSensitive) throws Exception {
        super(maxPhraseLength, caseSensitive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> phrases) throws Exception {
        if (!(corpusAccess instanceof TemporalCorpusAccessor)) {
            throw new IllegalArgumentException("Did not supply a TemporalCorpusAccessor");
        }
        TemporalCorpusAccessor temporalAccess = (TemporalCorpusAccessor)corpusAccess;
        HashMap<String, EquivalenceClass> eqsMap = new HashMap<String, EquivalenceClass>(phrases.size());
        for (EquivalenceClass equivalenceClass : phrases) {
            for (String word : equivalenceClass.getAllWords()) {
                assert (eqsMap.get(word) == null);
                eqsMap.put(word, equivalenceClass);
            }
        }
        for (EquivalenceClass equivalenceClass : phrases) {
            equivalenceClass.setProperty(new TimeDistribution());
        }
        this.m_binIdxs.clear();
        temporalAccess.resetDays();
        boolean bl = false;
        while (temporalAccess.nextDay()) {
            void var5_10;
            if (this.recordCurDayCounts((int)var5_10, this.getCurDayCounts(temporalAccess, eqsMap))) {
                this.m_binIdxs.add((int)var5_10);
            }
            ++var5_10;
        }
    }

    public Set<Integer> binsCollected() {
        return this.m_binIdxs;
    }

    protected boolean recordCurDayCounts(int curDayIdx, HashMap<EquivalenceClass, Integer> curDayCounts) {
        if (curDayCounts != null && curDayCounts.size() > 0) {
            for (EquivalenceClass eq : curDayCounts.keySet()) {
                ((TimeDistribution)eq.getProperty(TimeDistribution.class.getName())).addBin(curDayIdx, curDayCounts.get(eq));
            }
        }
        return curDayCounts != null && curDayCounts.size() > 0;
    }

    protected HashMap<EquivalenceClass, Integer> getCurDayCounts(TemporalCorpusAccessor temporalAccess, HashMap<String, EquivalenceClass> phMap) throws Exception {
        HashMap<EquivalenceClass, Integer> counts = null;
        BufferedReader reader = new BufferedReader(temporalAccess.getCurDayReader());
        if (reader != null && reader.ready()) {
            String curLine;
            counts = new HashMap<EquivalenceClass, Integer>();
            while ((curLine = reader.readLine()) != null) {
                curLine = curLine.trim();
                List<String> curSents = PhraseTimeDistributionCollector.getSentences(curLine, temporalAccess.isOneSentencePerLine());
                for (String sent : curSents) {
                    List<PhrasePropertyCollector.IdxPair> sentPhraseIdxs = PhraseTimeDistributionCollector.getAllPhraseIdxs(sent, this.m_maxPhraseLength);
                    for (PhrasePropertyCollector.IdxPair phraseIdx : sentPhraseIdxs) {
                        EquivalenceClass foundEq = phMap.get(EquivalenceClass.getWordOfAppropriateForm(sent.substring(phraseIdx.from, phraseIdx.to), this.m_caseSensitive));
                        if (foundEq == null) continue;
                        Integer count = (Integer)counts.get(foundEq);
                        counts.put(foundEq, count == null ? 1 : count + 1);
                    }
                }
            }
            reader.close();
        }
        return counts;
    }
}

