/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses;

import babel.content.eqclasses.EquivalenceClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

public class PrefixEquivalenceClass
extends EquivalenceClass {
    protected static final int MIN_PREFIX_SIZE = 5;
    protected String m_prefix = null;
    protected HashSet<String> m_endings;
    protected HashSet<String> m_allWords = new HashSet();

    public PrefixEquivalenceClass() {
        this.m_endings = new HashSet();
    }

    @Override
    public void init(String word, boolean caseSensitive) {
        super.init(word, caseSensitive);
        this.m_prefix = PrefixEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive);
        this.m_endings.clear();
        this.m_endings.add("");
        this.m_allWords.clear();
    }

    @Override
    public boolean isInEqClass(String word) {
        this.checkInitialized();
        String tmpWord = PrefixEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive);
        return tmpWord != null && (this.m_prefix.equals(tmpWord) || this.longestCommonPrefix(tmpWord, this.m_prefix) >= 5);
    }

    @Override
    public boolean addMorph(String word) {
        this.checkInitialized();
        int prefLength = 0;
        String tmpWord = PrefixEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive);
        boolean added = this.m_prefix.equals(tmpWord);
        if (!added && tmpWord != null && (prefLength = this.longestCommonPrefix(tmpWord, this.m_prefix)) >= 5) {
            if (prefLength < this.m_prefix.length()) {
                this.processEnding(this.m_prefix.substring(prefLength, this.m_prefix.length()));
                this.m_prefix = this.m_prefix.substring(0, prefLength);
            }
            if (prefLength < tmpWord.length()) {
                String newEnding = tmpWord.substring(prefLength, tmpWord.length());
                if (!this.m_endings.contains(newEnding)) {
                    this.m_endings.add(newEnding);
                }
            } else {
                this.m_endings.add("");
            }
            added = true;
        }
        return added;
    }

    @Override
    public String getStem() {
        return this.m_prefix.substring(0, Math.min(5, this.m_prefix.length()));
    }

    @Override
    public Collection<String> getAllWords() {
        this.checkInitialized();
        if (this.m_allWords.size() != this.m_endings.size()) {
            this.m_allWords.clear();
            for (String ending : this.m_endings) {
                this.m_allWords.add(String.valueOf(this.m_prefix) + ending);
            }
        }
        return this.m_allWords;
    }

    @Override
    public String persistToString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append(this.m_id);
        strBld.append("\t");
        strBld.append(this.m_initialized);
        strBld.append("\t");
        strBld.append(this.m_caseSensitive);
        strBld.append("\t");
        strBld.append(this.toString());
        return strBld.toString();
    }

    @Override
    public void unpersistFromString(String str) throws Exception {
        String[] toks = str.split("\t");
        this.m_id = Long.parseLong(toks[0]);
        this.m_initialized = Boolean.parseBoolean(toks[1]);
        this.m_caseSensitive = Boolean.parseBoolean(toks[2]);
        this.m_allWords.clear();
        this.m_endings.clear();
        this.m_properties.clear();
        StringTokenizer tokenizer = new StringTokenizer(toks[3], "{} ,");
        this.m_prefix = tokenizer.nextToken();
        boolean addedEndings = false;
        while (tokenizer.hasMoreTokens()) {
            this.m_endings.add(tokenizer.nextToken().substring(1));
            addedEndings = true;
        }
        if (!addedEndings) {
            this.m_endings.add("");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.m_prefix);
        if (this.m_endings.size() > 1 || this.m_endings.size() == 1 && !this.m_endings.contains("")) {
            boolean first = true;
            for (String ending : this.m_endings) {
                if (first) {
                    result.append(" {-");
                    first = false;
                } else {
                    result.append(", -");
                }
                result.append(ending);
            }
            result.append("}");
        }
        return result.toString();
    }

    @Override
    public boolean merge(EquivalenceClass eq) {
        boolean merged = false;
        if (this.sameEqClass(eq)) {
            for (String word : eq.getAllWords()) {
                this.addMorph(word);
            }
        }
        return merged;
    }

    protected int longestCommonPrefix(String one, String two) {
        int minSize = Math.min(one.length(), two.length());
        int prefLength = 0;
        while (prefLength < minSize) {
            if (one.charAt(prefLength) != two.charAt(prefLength)) break;
            ++prefLength;
        }
        return prefLength;
    }

    protected void processEnding(String str) {
        HashSet<String> newEndings = new HashSet<String>();
        for (String ending : this.m_endings) {
            newEndings.add(String.valueOf(str) + ending);
        }
        this.m_endings = newEndings;
    }

    protected String getAllWordsString() {
        return this.toString();
    }
}

