/*
 * Decompiled with CFR 0.152.
 */
package babel.content.corpora.accessors;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.corpora.accessors.TemporalCorpusAccessor;
import babel.util.misc.FileList;
import babel.util.misc.PrefixSuffixFileNameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrawlCorpusAccessor
extends TemporalCorpusAccessor {
    protected static final Log LOG = LogFactory.getLog(CrawlCorpusAccessor.class);
    protected static final String DEFAULT_CHARSET = "UTF-8";
    protected GregorianCalendar m_fromDate;
    protected GregorianCalendar m_toDate;
    protected GregorianCalendar m_curDate;
    protected int m_curFileNum;
    protected String m_encoding;
    protected FileList m_files;

    public CrawlCorpusAccessor(String corpusDir, String charset, Date from, Date to, boolean oneSentPerLine) {
        super(oneSentPerLine);
        if (from == null || to == null || from.after(to)) {
            throw new IllegalArgumentException("Dates missing / bad");
        }
        this.m_fromDate = new GregorianCalendar();
        this.m_fromDate.setTime(from);
        this.m_toDate = new GregorianCalendar();
        this.m_toDate.setTime(to);
        this.resetDays();
        this.resetFiles();
        this.m_encoding = charset;
        this.m_files = new FileList(corpusDir);
    }

    public CrawlCorpusAccessor(String corpusDir, Date from, Date to, boolean oneSentPerLine) {
        this(corpusDir, DEFAULT_CHARSET, from, to, oneSentPerLine);
    }

    @Override
    public InputStreamReader getCorpusReader() {
        InputStreamReader retReader = null;
        this.m_files.gather(2);
        try {
            retReader = new InputStreamReader((InputStream)new SequenceInputStream(this.m_files), this.m_encoding);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return retReader;
    }

    @Override
    public boolean resetDays() {
        this.m_curDate = null;
        return true;
    }

    @Override
    public boolean resetFiles() {
        this.m_curFileNum = -1;
        return true;
    }

    @Override
    public boolean nextFile() {
        boolean hasNext = false;
        if (this.m_curFileNum == -1) {
            this.m_files.gather(2);
            hasNext = this.m_files.size() > 0;
            if (hasNext) {
                this.m_curFileNum = 0;
            }
        } else {
            hasNext = this.m_curFileNum + 1 < this.m_files.size();
            if (hasNext) {
                ++this.m_curFileNum;
            }
        }
        return hasNext;
    }

    @Override
    public CorpusAccessor.NamedInputStreamReader getCurFileReader() {
        CorpusAccessor.NamedInputStreamReader namedReader = null;
        try {
            if (this.m_curFileNum != -1) {
                String fileName = this.m_files.getFileName(this.m_curFileNum);
                int lastSlashIdx = fileName.lastIndexOf(47);
                String fileHandle = lastSlashIdx >= 0 ? fileName.substring(lastSlashIdx + 1) : fileName;
                namedReader = new CorpusAccessor.NamedInputStreamReader(fileHandle, new InputStreamReader((InputStream)new FileInputStream(fileName), this.m_encoding));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return namedReader;
    }

    @Override
    public InputStreamReader getCurDayReader() {
        InputStreamReader retReader = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-d");
        StringBuilder yearSubdir = new StringBuilder(this.m_files.getDir());
        if (yearSubdir.length() > 0 && !File.separator.equals(yearSubdir.substring(yearSubdir.length() - 1))) {
            yearSubdir.append(File.separator);
        }
        yearSubdir.append(this.m_curDate.get(1));
        yearSubdir.append(File.separator);
        PrefixSuffixFileNameFilter nameFilter = new PrefixSuffixFileNameFilter(sdf.format(this.m_curDate.getTime()), null);
        FileList curDayFiles = new FileList(yearSubdir.toString(), nameFilter);
        curDayFiles.gather();
        try {
            retReader = new InputStreamReader((InputStream)new SequenceInputStream(curDayFiles), this.m_encoding);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return retReader;
    }

    @Override
    public Date getCurDay() {
        return this.m_curDate.getTime();
    }

    @Override
    public boolean nextDay() {
        boolean success = true;
        if (this.m_curDate == null) {
            this.m_curDate = new GregorianCalendar(this.m_fromDate.get(1), this.m_fromDate.get(2), this.m_fromDate.get(5));
        } else {
            this.m_curDate.add(5, 1);
            success = this.m_curDate.before(this.m_toDate);
        }
        return success;
    }
}

