/*
 * Decompiled with CFR 0.152.
 */
package tsg.evalHeads;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Scanner;
import java.util.Vector;
import tsg.TSNode;
import tsg.corpora.ConstCorpusTiger;
import util.FileUtil;

public class TigerDB2Heads {
    public static int[] readIndexes() {
        File indexFile = new File("sentenceIndexes.txt");
        String line = "";
        try {
            Scanner scan = new Scanner(indexFile);
            while (scan.hasNextLine()) {
                line = String.valueOf(line) + scan.nextLine();
            }
            scan.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
        line = line.trim();
        String[] indexeStrings = line.split(", ");
        int[] result = new int[indexeStrings.length];
        int i = 0;
        while (i < indexeStrings.length) {
            result[i] = Integer.parseInt(indexeStrings[i]);
            ++i;
        }
        return result;
    }

    public static void assignHeads(File indexBinaryFIle, File tigerTBCorpusFile, File outputFile) {
        Vector structure = (Vector)FileUtil.fromBinaryFile(indexBinaryFIle);
        ConstCorpusTiger tigerTBCorpus = new ConstCorpusTiger(tigerTBCorpusFile, "tigerTBCorpus");
        int[] indexes = TigerDB2Heads.readIndexes();
        tigerTBCorpus = tigerTBCorpus.returnIndexes(indexes);
        tigerTBCorpus.removeDoubleQuoteTiger();
        int index = 0;
        for (TSNode t : tigerTBCorpus.treeBank) {
            BitSet bs = (BitSet)structure.get(index);
            t.assignHeadFromBitSet(bs);
            ++index;
        }
        tigerTBCorpus.toFile_Complete(outputFile, true);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("The parameters are not correct.");
            System.err.println("Please use: java -jar TigerDB2Heads.jar <tigerTBCorpusFile> <outputFile>");
            return;
        }
        File tigerTBCorpusFile = new File(args[0]);
        if (!tigerTBCorpusFile.isFile()) {
            System.err.println("File " + args[0] + " does not exist.");
            return;
        }
        File outputFile = new File(args[1]);
        File headIndexFile = new File("HeadIndexBinaryFile");
        TigerDB2Heads.assignHeads(headIndexFile, tigerTBCorpusFile, outputFile);
    }
}

