/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.Hashtable;
import settings.Parameters;

public class Label {
    protected static Hashtable<String, Label> IDtableLabel = new Hashtable();
    protected static int labelCounter;
    public String labelString;

    public static int getLabelCounter() {
        return labelCounter;
    }

    public static void reset() {
        IDtableLabel.clear();
        labelCounter = 0;
    }

    private Label(String labelString) {
        this.labelString = labelString;
    }

    public static synchronized Label getLabel(String labelString) {
        Label storedLabel = IDtableLabel.get(labelString);
        if (storedLabel != null) {
            return storedLabel;
        }
        if (labelCounter == Integer.MAX_VALUE) {
            Parameters.reportError("Label reached max capacity!");
            return null;
        }
        ++labelCounter;
        storedLabel = new Label(labelString);
        IDtableLabel.put(labelString, storedLabel);
        return storedLabel;
    }

    public String toString() {
        return this.labelString;
    }

    public String toStringWithoutSemTags() {
        int dash_index = this.labelString.indexOf(45);
        if (dash_index > 0) {
            return this.labelString.substring(0, dash_index);
        }
        return this.labelString;
    }

    public String[] getSemTags() {
        return this.labelString.split("[-=]");
    }

    public boolean hasSemTags() {
        return this.labelString.indexOf(45) > 0;
    }

    public Label getLabelWithoutSemTags() {
        int dashIndex = this.labelString.indexOf(45);
        if (dashIndex == -1) {
            return this;
        }
        return Label.getLabel(this.labelString.substring(0, dashIndex));
    }

    public boolean equals(Object anObject) {
        return this == anObject;
    }

    public int hashCode() {
        return this.labelString.hashCode();
    }

    public static Label[] getLabelArray(String[] lex) {
        Label[] result = new Label[lex.length];
        int i = 0;
        while (i < lex.length) {
            result[i] = Label.getLabel(lex[i]);
            ++i;
        }
        return result;
    }
}

