/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.BitSet;
import kernels.NodeSetCollector;

public class NodeSetCollectorUnion
extends NodeSetCollector {
    BitSet singleUnion;
    int cardinality;

    public BitSet singleBS() {
        return this.singleUnion;
    }

    @Override
    public void makeEmpty() {
        this.singleUnion.clear();
        this.cardinality = 0;
    }

    @Override
    public Object clone() {
        NodeSetCollectorUnion clone = new NodeSetCollectorUnion();
        clone.singleUnion = this.singleUnion == null ? null : (BitSet)this.singleUnion.clone();
        clone.cardinality = this.cardinality;
        return clone;
    }

    @Override
    public boolean add(BitSet newBs) {
        if (this.singleUnion == null) {
            this.singleUnion = (BitSet)newBs.clone();
            return true;
        }
        this.singleUnion.or(newBs);
        int newCardinality = this.singleUnion.cardinality();
        if (this.cardinality != newCardinality) {
            this.cardinality = newCardinality;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(NodeSetCollector collector) {
        NodeSetCollectorUnion coll = (NodeSetCollectorUnion)collector;
        return this.add(coll.singleUnion);
    }

    @Override
    public boolean addAllCombinations(NodeSetCollector[] collectors, int[] collectorsSizes, int defaultBitSet) {
        boolean modified = !this.singleUnion.get(defaultBitSet);
        this.singleUnion.set(defaultBitSet);
        NodeSetCollector[] nodeSetCollectorArray = collectors;
        int n = collectors.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollector coll = nodeSetCollectorArray[n2];
            modified = this.addAll(coll) || modified;
            ++n2;
        }
        if (modified) {
            this.cardinality = this.singleUnion.cardinality();
        }
        return modified;
    }

    @Override
    public boolean removeSingleton(int index) {
        if (this.cardinality == 1 && this.singleUnion.get(index)) {
            this.singleUnion.clear();
            this.cardinality = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUniqueSingleton() {
        if (this.cardinality == 1) {
            this.singleUnion.clear();
            this.cardinality = 0;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.singleUnion == null ? 0 : 1;
    }

    @Override
    public BitSet[] getBitSetsAsArray() {
        BitSet[] bitSetArray;
        if (this.singleUnion == null) {
            bitSetArray = null;
        } else {
            BitSet[] bitSetArray2 = new BitSet[1];
            bitSetArray = bitSetArray2;
            bitSetArray2[0] = this.singleUnion;
        }
        return bitSetArray;
    }

    @Override
    public String toString() {
        return this.singleUnion.toString();
    }

    @Override
    public int maxCardinality() {
        return this.cardinality;
    }

    @Override
    public BitSet uniteSubGraphs() {
        return this.singleUnion == null ? null : (BitSet)this.singleUnion.clone();
    }
}

