/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import util.Pair;

public class AllOrderedCharSubsequencesNew {
    boolean[][] equalMatrix;
    Character[] a1;
    Character[] a2;
    int[][] subSequencesSizeMatrix;
    int xMax;
    int yMax;
    int xLength;
    int yLength;
    int matched;

    public AllOrderedCharSubsequencesNew(Character[] a1, Character[] a2) {
        this.a1 = a1;
        this.a2 = a2;
        this.xLength = a1.length;
        this.yLength = a2.length;
        this.xMax = a1.length - 1;
        this.yMax = a2.length - 1;
        this.equalMatrix = new boolean[this.xLength][this.yLength];
        this.subSequencesSizeMatrix = new int[this.xLength][this.yLength];
        int i = 0;
        while (i < a1.length) {
            int j = 0;
            while (j < a2.length) {
                this.subSequencesSizeMatrix[i][j] = -1;
                if (a1[i].equals(a2[j])) {
                    this.equalMatrix[i][j] = true;
                    ++this.matched;
                }
                ++j;
            }
            ++i;
        }
    }

    public int getNumberSubsequences() {
        if (this.matched == 0) {
            return 0;
        }
        int result = 0;
        int startX = 0;
        int startY = 0;
        int endY = this.yMax;
        int endX = this.xMax;
        boolean startXExists = startX < this.xLength;
        boolean startYExists = startY < this.yLength;
        while (startXExists || startYExists) {
            if (startXExists) {
                int cellY = endY;
                while (cellY > startY) {
                    if (this.equalMatrix[startX][cellY]) {
                        endY = cellY;
                        result += this.getNumberSubsequences(startX, cellY);
                    }
                    --cellY;
                }
            }
            if (startYExists) {
                int cellX = endX;
                while (cellX > startX) {
                    if (this.equalMatrix[cellX][startY]) {
                        endX = cellX;
                        result += this.getNumberSubsequences(cellX, startY);
                    }
                    --cellX;
                }
            }
            if (startXExists && startYExists && this.equalMatrix[startX][startY]) {
                result += this.getNumberSubsequences(startX, startY);
                break;
            }
            if (startXExists) {
                if (startX + 1 <= endX) {
                    ++startX;
                } else {
                    startXExists = false;
                }
            }
            if (!startYExists) continue;
            if (startY + 1 <= endY) {
                ++startY;
                continue;
            }
            startYExists = false;
        }
        return result;
    }

    private int getNumberSubsequences(int x, int y) {
        int stored = this.subSequencesSizeMatrix[x][y];
        if (stored != -1) {
            return stored;
        }
        stored = 0;
        int startX = x + 1;
        int startY = y + 1;
        int endY = this.yMax;
        int endX = this.xMax;
        boolean startXExists = startX < this.xLength;
        boolean startYExists = startY < this.yLength;
        while (startXExists || startYExists) {
            if (startXExists) {
                int cellY = endY;
                while (cellY > startY) {
                    if (this.equalMatrix[startX][cellY]) {
                        endY = cellY;
                        stored += this.getNumberSubsequences(startX, cellY);
                    }
                    --cellY;
                }
            }
            if (startYExists) {
                int cellX = endX;
                while (cellX > startX) {
                    if (this.equalMatrix[cellX][startY]) {
                        endX = cellX;
                        stored += this.getNumberSubsequences(cellX, startY);
                    }
                    --cellX;
                }
            }
            if (startXExists && startYExists && this.equalMatrix[startX][startY]) {
                stored += this.getNumberSubsequences(startX, startY);
                break;
            }
            if (startXExists) {
                if (startX + 1 <= endX) {
                    ++startX;
                } else {
                    startXExists = false;
                }
            }
            if (startYExists) {
                if (startY + 1 <= endY) {
                    ++startY;
                } else {
                    startYExists = false;
                }
            }
            if (stored != 0) continue;
            stored = 1;
        }
        int n = stored;
        this.subSequencesSizeMatrix[x][y] = n;
        return n;
    }

    public ArrayList<ArrayList<Pair<Character>>> getAllSubsequences() {
        return this.getAllSubsequences(0, 0, true);
    }

    private ArrayList<ArrayList<Pair<Character>>> getAllSubsequences(int x, int y, boolean sumAll) {
        ArrayList<ArrayList<Pair<Character>>> result = new ArrayList<ArrayList<Pair<Character>>>();
        int startX = sumAll ? x : x + 1;
        int startY = sumAll ? y : y + 1;
        int endY = this.yMax;
        int endX = this.xMax;
        boolean startXExists = startX < this.xLength;
        boolean startYExists = startY < this.yLength;
        while (startXExists || startYExists) {
            if (startXExists) {
                int cellY = endY;
                while (cellY > startY) {
                    if (this.equalMatrix[startX][cellY]) {
                        endY = cellY;
                        this.addSubSequences(result, this.getAllSubsequences(startX, cellY, false), x, y, sumAll);
                    }
                    --cellY;
                }
            }
            if (startYExists) {
                int cellX = endX;
                while (cellX > startX) {
                    if (this.equalMatrix[cellX][startY]) {
                        endX = cellX;
                        this.addSubSequences(result, this.getAllSubsequences(cellX, startY, false), x, y, sumAll);
                    }
                    --cellX;
                }
            }
            if (startXExists && startYExists && this.equalMatrix[startX][startY]) {
                this.addSubSequences(result, this.getAllSubsequences(startX, startY, false), x, y, sumAll);
                break;
            }
            if (startXExists) {
                if (startX + 1 <= endX) {
                    ++startX;
                } else {
                    startXExists = false;
                }
            }
            if (!startYExists) continue;
            if (startY + 1 <= endY) {
                ++startY;
                continue;
            }
            startYExists = false;
        }
        if (result.isEmpty()) {
            ArrayList<Pair<Character>> singlePairMapping = new ArrayList<Pair<Character>>(1);
            singlePairMapping.add(new Pair<Character>(this.a1[x], this.a2[y]));
            result.add(singlePairMapping);
        }
        return result;
    }

    public static int indexOf(Character c, Character[] a) {
        int i = 0;
        while (i < a.length) {
            if (c == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addSubSequences(ArrayList<ArrayList<Pair<Character>>> result, ArrayList<ArrayList<Pair<Character>>> otherSubSequences, int x, int y, boolean sumAll) {
        if (sumAll) {
            result.addAll(otherSubSequences);
        } else {
            Pair<Character> pair = new Pair<Character>(this.a1[x], this.a2[y]);
            for (ArrayList<Pair<Character>> otherListPair : otherSubSequences) {
                ArrayList<Pair<Character>> newListPair = new ArrayList<Pair<Character>>(otherListPair.size() + 1);
                newListPair.add(pair);
                newListPair.addAll(otherListPair);
                result.add(newListPair);
            }
        }
    }

    public static String toString(ArrayList<Pair<Character>> pairList, Character[] a1, Character[] a2) {
        String result = "(";
        ListIterator<Pair<Character>> iter2 = pairList.listIterator();
        while (iter2.hasNext()) {
            Pair<Character> p = iter2.next();
            Character c1 = p.getFirst();
            Character c2 = p.getSecond();
            int i1 = AllOrderedCharSubsequencesNew.indexOf(c1, a1);
            int i2 = AllOrderedCharSubsequencesNew.indexOf(c2, a2);
            result = String.valueOf(result) + "(" + c1 + i1 + "," + c2 + i2 + ")";
            if (!iter2.hasNext()) continue;
            result = String.valueOf(result) + ", ";
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public static Character[] makeNewCharArray(Character[] array) {
        Character[] result = new Character[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = new Character(array[i].charValue());
            ++i;
        }
        return result;
    }

    public static void main1(String[] args) {
        Character[] a1 = AllOrderedCharSubsequencesNew.makeNewCharArray(new Character[]{Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('C'), Character.valueOf('N')});
        Character[] a2 = AllOrderedCharSubsequencesNew.makeNewCharArray(new Character[]{Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf(','), Character.valueOf('N'), Character.valueOf('C'), Character.valueOf('N')});
        AllOrderedCharSubsequencesNew S = new AllOrderedCharSubsequencesNew(a1, a2);
        ArrayList<ArrayList<Pair<Character>>> allS = S.getAllSubsequences();
        for (ArrayList<Pair<Character>> pairList : allS) {
            System.out.println(pairList);
        }
        System.out.println(allS.size());
    }

    public static void main(String[] args) {
        Object[] a1 = AllOrderedCharSubsequencesNew.makeNewCharArray(new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('B'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('B')});
        Object[] a2 = AllOrderedCharSubsequencesNew.makeNewCharArray(new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('B')});
        AllOrderedCharSubsequencesNew S2 = new AllOrderedCharSubsequencesNew((Character[])a1, (Character[])a2);
        ArrayList<ArrayList<Pair<Character>>> allS2 = S2.getAllSubsequences();
        System.out.println(Arrays.toString(a1));
        System.out.println(Arrays.toString(a2));
        for (ArrayList<Pair<Character>> pairList : allS2) {
            System.out.println(AllOrderedCharSubsequencesNew.toString(pairList, (Character[])a1, (Character[])a2));
        }
        System.out.println(allS2.size());
    }
}

