# Recognizing Value Resonance with Resonance-Tuned RoBERTa:
## Task Definition, Experimental Validation, and Robust Modeling
---
# Supplementary Materials Repository

This repository contains supplemental materials for the paper *Recognizing Value Resonance with Resonance-Tuned RoBERTa: Task Definition, Experimental Validation, and Robust Modeling*. The enclosed materials include trained models, experimental data, notebooks for result replication, and scripts used for data processing, model evaluation, and model finetuning.

# Directory Outline
---
- Code
- Data
- Models
- LISCENCE

# Code
--- 
The `code` directory contains all scripts and notebooks required for replicating paper results and training RVR models.

Subdirectory Outline
- Notebooks
- Scripts
- Pipfile

## Notebooks

The `notebooks` directory contains the Jupyter notebook used for result replication and analysis.
- Paper_Result_Replication.ipynb: Notebook for replicating paper results.

## Scripts 

The `scripts` directory contains Python scripts used for:

Result replication:
- main.py: Script containing main functionality used by replication notebook.
- data_processing.py: Script for data processing.
- model_evaluation.py: Script for model evaluation.
- plotting.py: Script for plotting results.
- value_resonance_scorer.py: Object for value-resonance classification

and Model training:
- torch_tuning_resonance_roberta.py: Script for training new Res-Roberta models.

## Pipfile

The environment file necessary to run enclosed code

# Data
---
This directory includes all supplemental data related to the experiments conducted in the accompanying paper.

Subdirectory Outline
- WVC:
    - Annonymized_WVC.csv: Anonymized World Values Corpus.
    - RVR_coded_WVC.csv: RVR coded World Values Corpus.
    - WVC_prefix_prepended_hypotheses.csv: WVC hypotheses with alternate prefix structures.
    - WVC_stem_encoding.csv: Stem encodings for WVC hypotheses.
- RVR_Modeling_Noise: Data for RVR Modeling with added noise.
- RVR_Modeling_Touche: Data for RVR Modeling with Touche Human Values Extension.
- RVR_Modeling_WVC: Data for RVR Modeling with World Values Corpus.
- Prefix_Experiment: Data for the Prefix Experiment.
- LLM_Experiment: Results from the Large Language Model Experiment.

## WVC

This directory contains the following files:

- Annonymized_WVC.csv: Anonymized World Values Corpus.
- RVR_coded_WVC.csv: RVR coded World Values Corpus.
- WVC_prefix_prepended_hypotheses.csv: WVC hypotheses with alternate prefix structures.
- WVC_stem_encoding.csv: Stem encodings for WVC hypotheses.

## RVR_Modeling_

The subdirectories beginning `RVR_Modeling_` contain:
- training_set.csv: Training set for relevant RVR Modeling.
- validation_set.csv: Validation set for relevant RVR Modeling
- testing_set.csv: Testing set for relevant RVR Modeling.

## Prefix_Experiment

This directory contains the data used during the hypothesis stemming and prefix assignment study.
- prefix_study_combined_test_set.csv: The combined test set for all hypothesis structures covered in the prefix experiment.
- prefix_study_combined_training_set.csv: The combined training set for all hypothesis structures covered in the prefix experiment.

# Models 
---
The `models` directory contains all trained models used in our experiments. Namely:
- RVR_Complete: Res-RoBERTa Complete.
- RVR_HVE: Res-RoBERTa Human Values Extension.
- RVR_WVC: Res-RoBERTa WVC.

Each model directory contains a `config.json` file and a `pytorch_model.bin` file.

# License
---
The materials in this supplement are provided under the license terms as outlined here. Please refer to the LICENSE file for more information.

For any questions or issues regarding the materials, feel free to contact the authors listed in the paper.