# Code Documentation

This documentation provides explanations and instructions on how to use the code. Follow the steps below to ensure a smooth execution and adjustment of the code.

## 1. Requirements

### Python Environment
Ensure you're using Python version 3.7 or higher.

### Dependencies
The following packages and their respective versions are required:

- `beir`
- `colbert`
- `openai`
- `tqdm`
- `torch>=1.18`
- `llama`
- `fairscale`
- `fire`
- `sentencepiece`
- `datasets`
- `tensorflow-text`
- `sentence_transformers`
- `faiss-cpu`

To install all dependencies, you can use:

pip install beir colbert openai tqdm torch>=1.18 llama fairscale fire sentencepiece datasets tensorflow-text sentence_transformers faiss-cpu


### Retrievers

For the retriever models:

- For the zero-shot versions:
  - [beir repository](https://github.com/beir-cellar/beir)
  - [ColBERT repository](https://github.com/stanford-futuredata/ColBERT)

- For fine-tuned versions, refer to the 'Fine-tune Retrievers' section to train them.

### LLM Reader

For experiments involving `gpt-3.5-turbo`:
- Configure the related API parameters in `api/azure_api_manager.py`.

For experiments with `llama-2-13b`:
- Download the `llama-2-13b` model from the [LLAMA repository](https://github.com/facebookresearch/llama).


## 2. Quick Start

After fulfilling the requirements:

1. Define the necessary parameters in `experiments/config.py`.
2. Run the experiment by executing the `run_pipeline.py`:

Follow the above steps to quickly reproduce the experimental results.


## 3. Fine-tune Retrievers


For fine-tuning our models, we utilized the official code released by the respective retrievers:

- **Splade**: Fine-tuned using the method from [Splade's official repository](https://github.com/naver/splade).
  
- **DPR**: Followed the approach provided in [DPR's official repository](https://github.com/facebookresearch/DPR).
  
- **ColBERT**: Adopted the approach from [ColBERT's official repository](https://github.com/stanford-futuredata/ColBERT).

- **Rerank Model**: Fine-tuned using the method available in [Tevatron's reranker example](https://github.com/texttron/tevatron/tree/main/examples/reranker).

Please visit the respective repositories for detailed steps and guidelines.




