import matplotlib.pyplot as plt

# Data
drift = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
holdout_accuracy = [0.09, 0.09, 0.11, 0.12, 0.15, 0.23, 0.39, 0.66, 0.84, 0.92, 0.93]
similarity = [0.89, 0.90, 0.90, 0.89, 0.89, 0.88, 0.87, 0.86, 0.84, 0.82, 0.82]

# Plotting
plt.figure(figsize=(10, 5))
# plt.plot(drift, holdout_accuracy, label='Holdout Accuracy', marker='x')
plt.plot(drift, similarity, label='Similarity', marker='x')
plt.xlabel('Drift')
plt.ylabel('Metric Value')
plt.title('Holdout Accuracy and Similarity vs. Drift')
plt.legend()
plt.grid(True)
plt.savefig('holdout_accuracy_similarity_vs_drift.png')
