import os

# User
user = os.environ["USER"]

# Device
device = 0

# Directories and file paths
def get_style_transfer_folder():
    return f'/exp/{user}/style_transfer'

def get_output_folder(folder_name):
    return os.path.join(get_style_transfer_folder(), f'{folder_name}')

def get_gpt3_cache_path():
    return os.path.join(get_style_transfer_folder(), 'gpt3_cache.db')

# Get safe filename
def make_safe_filename(s):
    import xxhash
    def safe_char(c):
        if c.isalnum():
            return c
        else:
            return "_"
    return "".join(safe_char(c) for c in s).rstrip("_") + "_" + xxhash.xxh32(s).hexdigest()
