## 👩‍🏫 Tutor-ICL Implementation.

** The implementation is largely based on the following paper: [THOR-ISA](http://haofei.vip/THOR/)
** Our sincere thanks to the authors!

----------

## Code Usage<a name="code" />


----------
### Requirement<a name="requirement" />

``` bash 
conda create -n thor python=3.8
```

``` bash
# CUDA 10.2
conda install pytorch==1.10.0 torchvision==0.11.0 torchaudio==0.10.0 cudatoolkit=10.2 -c pytorch

# CUDA 11.3
conda install pytorch==1.10.0 torchvision==0.11.0 torchaudio==0.10.0 cudatoolkit=11.3 -c pytorch -c conda-forge
```

```bash
pip install -r requirements.txt
```

----------

### Dataset<a name="data" />

SemEval14 Laptop ([laptops](data%2Flaptops)) and Restaurant ([restaurants](data%2Frestaurants)), with fine-grained target-level annotations.

----------

Use the [main.py](main.py) script with command-line arguments to run Tutor-ICL. 


```bash
python main.py -c <cuda_index> -r [thor|prompt] -d [restaurants|laptops] -z [True|False] -f <config_file>
```
Some important arguments:

- `-c`, `--cuda_index`: Index of the GPU to use for computation (default is 0).
- `-d`, `--data_name`: Name of the dataset. Choices are 'restaurants' or 'laptops' (default is 'laptops').
- `-f`, `--config`: Specifies the location of [config.yaml](config%2Fconfig.yaml) file.

Configurate more parameters in [config.yaml](config%2Fconfig.yaml) file.

----------

### License

The code is released under Apache License 2.0 for Noncommercial use only. 