import datetime
import os
import cv2
import numpy as np
from PIL import Image
import math


def image_crop(pil_imgae,boxes,image_path,idx):
    pil_image=cv2.imread(image_path)
    min_x = max(min([x for x, _ in boxes]),0)
    max_x = max([x for x, _ in boxes])
    min_y = max(min([y for _, y in boxes]),0)
    max_y = max([y for _, y in boxes])
    patch_image = pil_image[min_y:max_y, min_x:max_x]
    if image_path[-10:-4]=='reedit':
        save_image_path= image_path[:-11]+f'{idx}crop.png'
    else:
        save_image_path= image_path[:-4]+f'{idx}crop.png'
    cv2.imwrite(save_image_path,patch_image)
    return save_image_path


def image_crop_google(boxes,image_path,idx):
    pil_image=cv2.imread(image_path)
    min_x = max(min([x for x, _ in boxes]),0)
    max_x = max([x for x, _ in boxes])
    min_y = max(min([y for _, y in boxes]),0)
    max_y = max([y for _, y in boxes])
    patch_image = pil_image[min_y:max_y, min_x:max_x]
    save_image_path= image_path[:-4]+f'{idx}crop.png'
    cv2.imwrite(save_image_path,patch_image)
    return save_image_path

def save_images(img_list, folder):
    if not os.path.exists(folder):
        os.makedirs(folder)
    now = datetime.datetime.now()
    date_str = now.strftime("%Y-%m-%d")
    folder_path = os.path.join(folder, date_str)
    if not os.path.exists(folder_path):
        os.makedirs(folder_path)
    time_str = now.strftime("%H_%M_%S")
    for idx, img in enumerate(img_list):
        image_number = idx + 1
        filename = f"{time_str}_{image_number}.jpg"
        save_path = os.path.join(folder_path, filename)
        cv2.imwrite(save_path, img[..., ::-1])


def check_channels(image):
    channels = image.shape[2] if len(image.shape) == 3 else 1
    if channels == 1:
        image = cv2.cvtColor(image, cv2.COLOR_GRAY2BGR)
    elif channels > 3:
        image = image[:, :, :3]
    return image


def resize_image(img, max_length=768):
    height, width = img.shape[:2]
    max_dimension = max(height, width)

    if max_dimension > max_length:
        scale_factor = max_length / max_dimension
        new_width = int(round(width * scale_factor))
        new_height = int(round(height * scale_factor))
        new_size = (new_width, new_height)
        img = cv2.resize(img, new_size)
    height, width = img.shape[:2]
    img = cv2.resize(img, (width-(width % 64), height-(height % 64)))
    return img


def resize_image_boxes(img,boxes, max_length=768):
    height, width = img.shape[:2]
    height_original,width_original=height,width
    max_dimension = max(height, width)
    if max_dimension > max_length:
        scale_factor = max_length / max_dimension
        new_width = int(round(width * scale_factor))
        new_height = int(round(height * scale_factor))
        new_size = (new_width, new_height)
        img = cv2.resize(img, new_size)
    height, width = img.shape[:2]
    img = cv2.resize(img, (width-(width % 64), height-(height % 64)))
    height_end,width_end=img.shape[:2]
    height_scale=height_end/height_original
    width_scale=width_end/width_original

    new_boxes=[]
    for box_coordinates in boxes:
        box_coordinates=np.array(box_coordinates, dtype=np.int32)
        rect = cv2.minAreaRect(box_coordinates)
        center, size, angle = rect
        if angle<45:
    
            size_new=(size[0]*width_scale,size[1]*height_scale)    
        else:
            size_new=(size[0]*height_scale,size[1]*width_scale) 


        new_center = (center[0] * width_scale, center[1] * height_scale)          
        new_rect = (new_center, size_new, angle)
        new_box_coordinates = (cv2.boxPoints(new_rect).tolist())
        new_coords = []
        for i, coord in enumerate(new_box_coordinates):
            if i in (0, 1):
                new_coords.append([math.floor(x) for x in coord])
            elif i in (2, 3):  
                new_coords.append([math.ceil(x) for x in coord])
        new_boxes.append(new_coords)

    return img,new_boxes


def distance(pt1, pt2):
    return np.sqrt((pt1[0] - pt2[0])**2 + (pt1[1] - pt2[1])**2)

def enlarge_box_bigger(box):
    width=distance(box[0],box[1])
    height=distance(box[2],box[3])  
    delta_width=width*0.06
    delta_height=height*0.06
    box=np.array(box, dtype=np.int32)
    rect = cv2.minAreaRect(box)
    center, size, angle = rect
    if angle<45:
        size_new=(size[0]+delta_width,size[1]+delta_height)
    else:
        size_new=(size[0]+delta_height,size[1]+delta_width)
    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    return new_box


def resize_mask2(pil_image,box_coordinates):
    height,width = pil_image.shape[:2]
    box_coordinates = np.array(box_coordinates, dtype=np.int32)
    whether_erase=False

    dis_kuan=np.linalg.norm(box_coordinates[1]-box_coordinates[0])
    dis_gao=np.linalg.norm(box_coordinates[2]-box_coordinates[1])       
    rect = cv2.minAreaRect(box_coordinates)
    center, size, angle = rect
    scale_factor=word_count_new/word_count_old
    if mode=='ch2en':
        scale_factor=scale_factor/2.5
    elif mode=='en2ch' or mode=='fr2ch':
        scale_factor=scale_factor*1.8 
    else:
        scale_factor=scale_factor
    if scale_factor>=0.8 and scale_factor<=1.2:
        scale_factor=1
    
    if scale_factor<0.8:
        whether_erase=True
    if angle<45:
        size_new=(size[0]*scale_factor,size[1])    
    else:
        size_new=(size[0],size[1]*scale_factor)    
    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    new_box = np.int0(new_box)
    mask = np.zeros((height,width), dtype=np.uint8) 
    cv2.drawContours(mask, [new_box], 0, (255), -1)
    mask = 255 - mask
    return mask,whether_erase




def resize_mask(img_path,box_coordinates, word_count_old,word_count_new,mode):
    pil_image=cv2.imread(img_path)

    height,width = pil_image.shape[:2]
    box_coordinates = np.array(box_coordinates, dtype=np.int32)
    whether_erase=False

    dis_kuan=np.linalg.norm(box_coordinates[1]-box_coordinates[0])
    dis_gao=np.linalg.norm(box_coordinates[2]-box_coordinates[1])       
    rect = cv2.minAreaRect(box_coordinates)
    center, size, angle = rect
    scale_factor=word_count_new/word_count_old
    if mode=='ch2en':
        scale_factor=scale_factor/2.5
    elif mode=='en2ch' or mode=='fr2ch':
        scale_factor=scale_factor*1.8 
    else:
        scale_factor=scale_factor
    if scale_factor>=0.8 and scale_factor<=1.2:
        scale_factor=1
    
    if scale_factor<0.8:
        whether_erase=True
    if angle<45:
        size_new=(size[0]*scale_factor,size[1])    
    else:
        size_new=(size[0],size[1]*scale_factor)    
    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    new_box = np.int0(new_box)
    mask = np.zeros((height,width), dtype=np.uint8) 
    cv2.drawContours(mask, [new_box], 0, (255), -1)
    mask = 255 - mask
    return mask,whether_erase

def resize_mask_returnbox(img_path,box_coordinates, word_count_old,word_count_new,mode):
    pil_image=cv2.imread(img_path)
    height,width = pil_image.shape[:2]
    box_coordinates = np.array(box_coordinates, dtype=np.int32)
    whether_erase=False

    dis_kuan=np.linalg.norm(box_coordinates[1]-box_coordinates[0])
    dis_gao=np.linalg.norm(box_coordinates[2]-box_coordinates[1])       
    rect = cv2.minAreaRect(box_coordinates)
    center, size, angle = rect
    scale_factor=word_count_new/word_count_old
    if mode=='ch2en':
        scale_factor=scale_factor/3
    elif mode=='en2ch' or mode=='fr2ch':
        scale_factor=scale_factor*1.8 
    else:
        scale_factor=scale_factor
    if scale_factor>=0.8 and scale_factor<=1.2:
        scale_factor=1
    
    if scale_factor<0.8:
        whether_erase=True
    if angle<45:
        size_new=(size[0]*scale_factor,size[1])    
    else:
        size_new=(size[0],size[1]*scale_factor)    
    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    new_box = np.int0(new_box)
    mask = np.zeros((height,width), dtype=np.uint8) 
    cv2.drawContours(mask, [new_box], 0, (255), -1)
    mask = 255 - mask
    return mask,whether_erase,new_box

def resize_mask_returnbox_suokuan(img_path,box_coordinates, word_count_old,word_count_new,mode):
    pil_image=cv2.imread(img_path)
    height,width = pil_image.shape[:2]
    box_coordinates = np.array(box_coordinates, dtype=np.int32)
    whether_erase=False

    dis_kuan=np.linalg.norm(box_coordinates[1]-box_coordinates[0])
    dis_gao=np.linalg.norm(box_coordinates[2]-box_coordinates[1])       

    rect = cv2.minAreaRect(box_coordinates)
    center, size, angle = rect
    scale_factor=word_count_new/word_count_old
    if mode=='ch2en':
        scale_factor=scale_factor/2.9

    elif mode=='en2ch' or mode=='fr2ch':
        scale_factor=scale_factor*1.8
    elif mode=='en2jp':
        scale_factor=scale_factor/1.2
    else:
        scale_factor=scale_factor

    if scale_factor>=0.8 and scale_factor<=1.2:
        scale_factor=1
        size_new=(size[0],size[1])
    if scale_factor<0.8 and mode=='ch2en':
        scale_factor=1
        size_new=(size[0],size[1])
    if scale_factor<0.8 and mode!='ch2en':
        whether_erase=True
        if angle<45:
            size_new=(size[0]*scale_factor,size[1])    
        else:
            size_new=(size[0],size[1]*scale_factor)

    if scale_factor>1.2:
        whether_erase=True
        if angle<45:
            size_new=(size[0],size[1]/scale_factor)    
        else:
            size_new=(size[0]/scale_factor,size[1])

    new_rect = (center, size_new, angle)
    new_box = cv2.boxPoints(new_rect)
    new_box = np.int0(new_box)
    mask = np.zeros((height,width), dtype=np.uint8) 
    cv2.drawContours(mask, [new_box], 0, (255), -1)
    mask = 255 - mask
    return mask,whether_erase,new_box
