/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.SimpleConstituent;

public final class Span
extends SimpleConstituent {
    public Span() {
    }

    public Span(int start, int end) {
        super(start, end);
    }

    public boolean equals(Span sp) {
        return this.start() == sp.start() && this.end() == sp.end();
    }

    @Override
    public ConstituentFactory constituentFactory() {
        return ConstituentFactoryHolder.cf;
    }

    public static ConstituentFactory factory() {
        return ConstituentFactoryHolder.cf;
    }

    private static class ConstituentFactoryHolder {
        private static final ConstituentFactory cf = new SpanFactory();

        private ConstituentFactoryHolder() {
        }

        private static class SpanFactory
        implements ConstituentFactory {
            private SpanFactory() {
            }

            @Override
            public Constituent newConstituent(int start, int end) {
                return new Span(start, end);
            }

            @Override
            public Constituent newConstituent(int start, int end, Label label, double score) {
                return new Span(start, end);
            }
        }
    }
}

