
import os

import click


@click.command()
@click.option('--model_name', type=str, default="bert-base-uncased")
@click.option('--task', type=str)
@click.option('--batch_size', type=int, default=16)
@click.option('--learning_rate', type=float, default=0.00002)
@click.option('--no_fine_tuning', is_flag=True)
@click.option('--no_prompting', is_flag=True)
@click.option('--no_frozen', is_flag=True)
@click.option('--no_peft', is_flag=True)
def main(model_name, task, batch_size, learning_rate, no_fine_tuning, no_prompting, no_frozen, no_peft):
    if task is None:
        tasks = ["detox-toxic", "detox-sentiment", "detox-hate-speech"]
    else:
        tasks = [task]

    batch_size = str(batch_size)
    learning_rate = str(learning_rate)
    for seed in [0,1,2,3,4,5,6,7,8,9]:
        for fold in [0]:
            for task in tasks:
                os.system("python3 run_fine-tuning_multi_test.py --batch_size " + batch_size + " --learning_rate " + learning_rate + " --model_name " + model_name + " --fold " + str(fold) + " --seed " + str(seed) + " --setup it --pooling cls --task " + task)


if __name__ == "__main__":
    main()
