(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics written for Isabelle/Isar.

    Copyright (C) 2013 Daniel de la Concepcion

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. *)

section \<open>Topology 8\<close>

theory Topology_ZF_8 imports Topology_ZF_6 EquivClass1
begin

text\<open>Suppose $T$ is a topology, $r$ is an equivalence relation on $X = \bigcup T$
  and $P_r : X \rightarrow X/r$ maps an element of $X$ to its equivalence class 
  $r\{x \}$. Then we can define a topology (on $X/r$) by taking the collection of 
  those subsets $V$ of $X/r$ for which the inverse image by the projection $P_r$
  is in $T$. This is the weakest topology on $X/r$ such that $P_r$ is continuous.
  In this theory we consider a seemingly more general situation where we start with a topology 
  $T$ on $X=\bigcup T$ and a surjection $f:X\rightarrow Y$ and define
  a topology on $Y$ by taking those subsets $V$ of $Y$ for which the inverse image 
  by the mapping $f$ is in $T$. Turns out that this construction is in a way equivalent
  to the previous one as the topology defined this way is homeomorphic to
  the topology defined by the equivalence relation $r_f$ on $X$ that relates
  two elements of $X$ if $f$ has the same value on them. \<close>

subsection\<open>Definition of quotient topology\<close>

text\<open> In this section we define the quotient topology generated by a topology
  $T$ and a surjection $f:\bigcup T \rightarrow Y$, and show its basic properties.  \<close>

text\<open>For a topological space $X=\bigcup T$ and a surjection $f:X\rightarrow Y$
  we define \<open>{quotient topology in} Y {by} f\<close> as the collection of subsets
  of $Y$ whose inverse images by $f$ are open. \<close>

definition (in topology0)
  QuotientTop ("{quotient topology in}_{by}_" 80)
  where "f\<in>surj(\<Union>T,Y) \<Longrightarrow>{quotient topology in} Y {by} f \<equiv>
    {U\<in>Pow(Y). f-``U\<in>T}"

text\<open>Outside of the \<open>topology0\<close> context we will indicate also the generating
  topology and write \<open>{quotient topology in} Y {by} f {from} X\<close>. \<close>

abbreviation QuotientTopTop ("{quotient topology in}_{by}_{from}_")
  where "{quotient topology in} Y {by} f {from} T \<equiv> topology0.QuotientTop(T,Y,f)"

text\<open>The quotient topology is indeed a topology.\<close>

theorem (in topology0) quotientTop_is_top:
  assumes "f\<in>surj(\<Union>T,Y)"
  shows "({quotient topology in} Y {by} f) {is a topology}"
proof-
  have "({quotient topology in} Y {by} f)={U \<in> Pow(Y) . f-``(U) \<in> T}" using QuotientTop_def assms
    by auto 
  moreover
  {
    fix M x B assume M: "M \<subseteq> {U \<in> Pow(Y) . f-``(U) \<in> T}"
    then have "\<Union>M\<subseteq>Y" by blast 
    moreover have A1: "f-``(\<Union>M) = (\<Union>y\<in>(\<Union>M). f-``{y})" using vimage_eq_UN by blast
    moreover 
    {
      fix A assume "A\<in>M"
      with M have "A\<in>Pow(Y)" "f-``(A) \<in> T" by auto
      have "f-``(A) = (\<Union>y\<in>A. f-``{y})" using vimage_eq_UN by blast
    }
    hence "(\<Union>A\<in>M. f-``(A)) = (\<Union>y\<in>\<Union>M. f-``{y})" by auto
    with A1 have A2: "f-``(\<Union>M)=\<Union>{f-`` A. A\<in>M}" by auto
    moreover 
    {
      fix A assume "A\<in>M"
      with M have "f-``(A)\<in>T" by auto
    }
    hence "{f-``(A). A\<in>M}\<subseteq>T" by auto
    then have "(\<Union>{f-``(A). A\<in>M})\<in>T" 
      using topSpaceAssum unfolding IsATopology_def by auto
    with A2 have "(f-``(\<Union>M))\<in>T" by auto
    ultimately have "\<Union>M\<in>{U\<in>Pow(Y). f-``U\<in>T}" by auto
  }
  moreover
  {
    fix U V assume "U \<in> {U\<in>Pow(Y). f-``U\<in>T}" "V\<in>{U\<in>Pow(Y). f-``U\<in>T}"
    then have "U\<in>Pow(Y)" "V\<in>Pow(Y)" "f-``U\<in>T""f-``V\<in>T" by auto
    then have "f-``(U\<inter>V)\<in>T" using topSpaceAssum invim_inter_inter_invim assms
      unfolding IsATopology_def surj_def by auto
    with \<open>U\<in>Pow(Y)\<close> \<open>V\<in>Pow(Y)\<close> have "U\<inter>V\<in>{U\<in>Pow(Y). f-``(U)\<in>T}" by auto
  }
  ultimately show ?thesis using IsATopology_def by auto
qed

text\<open>The quotient function is continuous.\<close>

lemma (in topology0) quotient_func_cont:
  assumes "f\<in>surj(\<Union>T,Y)"
  shows "IsContinuous(T,({quotient topology in} Y {by} f),f)"
    unfolding IsContinuous_def using QuotientTop_def assms by auto

text\<open>One of the important properties of this topology, is that a function
from the quotient space is continuous iff the composition with the quotient
function is continuous.\<close>

theorem (in two_top_spaces0) cont_quotient_top:
  assumes "h\<in>surj(\<Union>\<tau>\<^sub>1,Y)" "g:Y\<rightarrow>\<Union>\<tau>\<^sub>2" "IsContinuous(\<tau>\<^sub>1,\<tau>\<^sub>2,g O h)"
  shows "IsContinuous(({quotient topology in} Y {by} h {from} \<tau>\<^sub>1),\<tau>\<^sub>2,g)"
proof-
  {
    fix U assume "U\<in>\<tau>\<^sub>2"
    with assms(3) have "(g O h)-``(U)\<in>\<tau>\<^sub>1" unfolding IsContinuous_def by auto
    then have "h-``(g-``(U))\<in>\<tau>\<^sub>1" using vimage_comp by auto
    with assms(1) have "g-``(U)\<in>({quotient topology in} Y {by} h {from} \<tau>\<^sub>1)" 
      using topology0.QuotientTop_def tau1_is_top func1_1_L3 assms(2) 
      unfolding topology0_def by auto
  }
  then show ?thesis unfolding IsContinuous_def by auto
qed

text\<open>The underlying set of the quotient topology is $Y$.\<close>

lemma (in topology0) total_quo_func:
  assumes "f\<in>surj(\<Union>T,Y)"
  shows "(\<Union>({quotient topology in} Y {by} f))=Y"
proof-
  from assms have "f-``Y=\<Union>T" using func1_1_L4 unfolding surj_def by auto moreover
  have "\<Union>T\<in>T" using topSpaceAssum unfolding IsATopology_def by auto ultimately
  have "Y\<in>({quotient topology in}Y{by}f{from}T)" using QuotientTop_def assms by auto
  then show ?thesis using QuotientTop_def assms by auto
qed

subsection\<open>Quotient topologies from equivalence relations\<close>

text\<open>In this section we will show that the quotient topologies come from
  an equivalence relation.\<close>

text\<open>The quotient projection $b\mapsto r\{ b\}$ is a function that maps the domain of the 
  relation to the quotient. Note we do not need to assume that $r$ is an equivalence relation. \<close>

lemma quotient_proj_fun:
  shows "{\<langle>b,r``{b}\<rangle>. b\<in>A}:A\<rightarrow>A//r" unfolding Pi_def function_def domain_def
    unfolding quotient_def by auto

text\<open>The quotient projection is a surjection. Again $r$ does not need to be an equivalence relation 
 here \<close>

lemma quotient_proj_surj:
  shows "{\<langle>b,r``{b}\<rangle>. b\<in>A}\<in>surj(A,A//r)"
proof-
  { fix y assume "y\<in>A//r"
    then obtain x where "x\<in>A" "y=r``{x}" unfolding quotient_def by auto
    then have "\<exists>x\<in>A. {\<langle>b,r``{b}\<rangle>. b\<in>A}`(x) = y" using ZF_fun_from_tot_val1 
      by auto
  }
  then show ?thesis using quotient_proj_fun unfolding surj_def by auto
qed 

text\<open>The inverse image of a subset $U$ of the quotient by the quotient projection is the union
   of $U$. Note since $U$ is a subset of $A/r$ it is a collection of equivalence classes.\<close>

lemma preim_equi_proj:
  assumes "U\<subseteq>A//r" "equiv(A,r)"
  shows "{\<langle>b,r``{b}\<rangle>. b\<in>A}-``(U) = \<Union>U"
proof
  {
    fix y assume "y\<in>\<Union>U"
    then obtain V where "y\<in>V" and "V\<in>U" by auto
    with assms have "y \<in> {\<langle>b,r``{b}\<rangle>. b\<in>A}-``(U)"
      using EquivClass_1_L1 EquivClass_1_L2 by blast
  }
  thus "\<Union>U\<subseteq>{\<langle>b,r``{b}\<rangle>. b\<in>A}-``U" by blast
  {
    fix y assume "y\<in>{\<langle>b,r``{b}\<rangle>. b\<in>A}-``U"
    then have yy: "y\<in>{x\<in>A. r``{x}\<in>U}" by auto
    hence "r``{y}\<in>U" by auto 
    moreover from yy have "y\<in>r``{y}" using assms equiv_class_self by auto 
    ultimately have "y\<in>\<Union>U" by auto
  }
  thus "{\<langle>b,r``{b}\<rangle>. b\<in>A}-``U\<subseteq>\<Union>U" by blast
qed

text\<open>Now we define what a quotient topology from an equivalence relation is:\<close>

definition (in topology0)
  EquivQuo ("{quotient by} _" 70)
  where "equiv(\<Union>T,r)\<Longrightarrow>({quotient by} r) \<equiv> {quotient topology in} (\<Union>T)//r {by} {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}"

text\<open>Outside of the \<open>topology0\<close> context we need to indicate the original topology. \<close>

abbreviation EquivQuoTop ("_{quotient by}_")
  where "T {quotient by} r \<equiv> topology0.EquivQuo(T,r)"

text\<open>First, another description of the topology (more intuitive):\<close>

theorem (in topology0) quotient_equiv_rel:
  assumes "equiv(\<Union>T,r)"
  shows "({quotient by}r)={U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}"
proof-
  have "({quotient topology in}(\<Union>T)//r{by}{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T})=
    {U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}"
    using QuotientTop_def quotient_proj_surj by auto 
  moreover have "{U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}={U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}"
  proof
    {
      fix U assume "U\<in>{U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}"
      with assms have "U\<in>{U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}" using preim_equi_proj by auto
    }
    thus "{U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}\<subseteq>{U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}" by auto
    {
      fix U assume "U\<in>{U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}"
      with assms have "U\<in>{U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}" using preim_equi_proj
        by auto
     }
     thus "{U\<in>Pow((\<Union>T)//r). \<Union>U\<in>T}\<subseteq>{U\<in>Pow((\<Union>T)//r). {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}-``U\<in>T}" by auto
   qed
  ultimately show ?thesis using EquivQuo_def assms by auto
qed

text\<open>We apply previous results to this topology.\<close>

theorem (in topology0) total_quo_equi:
  assumes "equiv(\<Union>T,r)"
  shows "\<Union>({quotient by}r)=(\<Union>T)//r"
  using total_quo_func quotient_proj_surj EquivQuo_def assms by auto

text\<open>The quotient by an equivalence relation is indeed a topology. \<close>

theorem (in topology0) equiv_quo_is_top:
  assumes "equiv(\<Union>T,r)"
  shows "({quotient by}r){is a topology}"
  using quotientTop_is_top quotient_proj_surj EquivQuo_def assms by auto

text\<open>The next theorem is the main result of this section: 
  all quotient topologies arise from an equivalence relation given by the quotient 
  function $f:X\to Y$. This means that any quotient topology is homeomorphic to a topology
  given by an equivalence relation quotient.\<close>

theorem (in topology0) equiv_quotient_top:
  assumes "f\<in>surj(\<Union>T,Y)"
  defines "r\<equiv>{\<langle>x,y\<rangle>\<in>\<Union>T\<times>\<Union>T. f`(x)=f`(y)}"
  defines "g\<equiv>{\<langle>y,f-``{y}\<rangle>. y\<in>Y}"
  shows "equiv(\<Union>T,r)" and 
    "IsAhomeomorphism(({quotient topology in}Y{by}f),({quotient by}r),g)"
proof-
  from assms(1) have ff: "f:\<Union>T\<rightarrow>Y" unfolding surj_def by auto
  from assms(2) show B: "equiv(\<Union>T,r)" 
    unfolding equiv_def refl_def sym_def trans_def r_def by auto
  have gg: "g:Y\<rightarrow>((\<Union>T)//r)"
  proof -
    { fix B assume "B\<in>g"
      then obtain y where Y:"y\<in>Y" "B=\<langle>y,f-``{y}\<rangle>" unfolding g_def 
        by auto
      then have "f-``{y}\<subseteq>\<Union>T" using func1_1_L3 ff by blast
      then have eq: "f-``{y}={x\<in>\<Union>T. \<langle>x,y\<rangle>\<in>f}" using vimage_iff by auto
      from assms(1) Y obtain A where A1: "A\<in>\<Union>T" "f`(A)=y" unfolding surj_def 
        by blast
      with ff have A: "A \<in> f-``{y}" using func1_1_L15 by simp
      { fix t assume "t\<in>f-``{y}"
        with A eq have "t\<in>\<Union>T" "A\<in>\<Union>T" "\<langle>t,y\<rangle>\<in>f" "\<langle>A,y\<rangle>\<in>f" by auto
        then have "f`t=f`A" using apply_equality assms(1) unfolding surj_def by auto
        with assms(2) \<open>t\<in>\<Union>T\<close>\<open>A\<in>\<Union>T\<close> have "\<langle>A,t\<rangle>\<in>r" by auto
        then have "t\<in>r``{A}" using image_iff by auto
      } hence "f-``{y}\<subseteq>r``{A}" by auto 
      moreover
      { fix t assume "t\<in>r``{A}"
        with assms(2) have un: "t\<in>\<Union>T" "A\<in>\<Union>T" and eq2: "f`(t)=f`(A)"
          using image_iff by simp_all
        from ff un have "\<langle>t,f`(t)\<rangle>\<in>f" using func1_1_L5A(1) by simp
        with eq2 A1 un eq have "t\<in>f-``{y}" by simp
      } hence "r``{A}\<subseteq>f-``{y}" by auto 
      ultimately have "f-``{y}=r``{A}" by auto
      with A1(1) have "f-``{y} \<in> (\<Union>T)//r" 
        using A1(1) unfolding quotient_def by auto
      with Y have "B\<in>Y\<times>(\<Union>T)//r" by auto
    } then show ?thesis unfolding Pi_def function_def domain_def g_def 
      by auto
  qed
  then have gg2: "g:Y\<rightarrow>(\<Union>({quotient by}r))" using total_quo_equi B 
    by auto
  { fix s assume S: "s\<in>({quotient topology in}Y{by}f)"
    then have "s\<in>Pow(Y)" and P: "f-``(s)\<in>T" 
      using QuotientTop_def topSpaceAssum assms(1) by auto
    have "f-``s=(\<Union>y\<in>s. f-``{y})" using vimage_eq_UN by blast 
    moreover
    from \<open>s\<in>Pow(Y)\<close> have "\<forall>y\<in>s. \<langle>y,f-``{y}\<rangle>\<in>g" unfolding g_def by auto
    then have "\<forall>y\<in>s. g`y=f-``{y}" using apply_equality gg by auto 
    ultimately have "f-``s=(\<Union>y\<in>s. g`y)" by auto
    with P have "(\<Union>y\<in>s. g`y)\<in>T" by auto 
    moreover from \<open>s\<in>Pow(Y)\<close> have "\<forall>y\<in>s. g`y\<in>(\<Union>T)//r" using apply_type gg by auto
    ultimately have "{g`y. y\<in>s}\<in>({quotient by}r)" using quotient_equiv_rel B by auto
    with \<open>s\<in>Pow(Y)\<close> have "g``s\<in>({quotient by}r)" using func_imagedef gg by auto
  } hence gopen: "\<forall>s\<in>({quotient topology in}Y{by}f). g``s\<in>(T{quotient by}r)" 
    by auto
  have pr_fun: "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}:\<Union>T\<rightarrow>(\<Union>T)//r" 
    using quotient_proj_fun by auto
  { fix b assume b: "b\<in>\<Union>T"
    have bY: "f`(b)\<in>Y" using apply_funtype ff b by auto
    with b have com: "(g O f)`b=g`(f`b)" using comp_fun_apply ff by auto
    from bY have pg: "\<langle>f`b,f-``({f`b})\<rangle>\<in>g" unfolding g_def by auto
    then have "g`(f`b) = f-``({f`b})" using apply_equality gg by auto
    with com have comeq: "(g O f)`b=f-``({f`b})" by auto
    from b have A: "f``{b}={f`b}" "{b}\<subseteq>\<Union>T" using func_imagedef ff by auto
    from A(2) have "b \<in> f-``(f `` {b})" using func1_1_L9 ff by blast
    with A(1) have "b\<in>f-``({f`b})" by auto 
    moreover from pg have "f-``({f`b})\<in>(\<Union>T)//r" using gg unfolding Pi_def 
      by auto
    ultimately have "r``{b}=f-``({f`b})" using EquivClass_1_L2 B by auto
    then have "(g O f)`b=r``{b}" using comeq by auto 
    moreover from b pr_fun have "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`b=r``{b}" 
      using apply_equality by simp
    ultimately  have "(g O f)`b={\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`b" by simp
  } hence reg: "\<forall>b\<in>\<Union>T. (g O f)`(b)={\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`(b)" by blast
  moreover have compp: "g O f\<in>\<Union>T\<rightarrow>(\<Union>T)//r" using comp_fun ff gg by blast
  moreover
  from compp pr_fun reg have feq: "(g O f)={\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}"
    by (rule func_eq)
  then have "IsContinuous(T,{quotient by}r,(g O f))" 
    using quotient_func_cont quotient_proj_surj EquivQuo_def topSpaceAssum B by auto 
  moreover have "(g O f):\<Union>T\<rightarrow>\<Union>({quotient by}r)" using comp_fun ff gg2 by auto
  ultimately have gcont: "IsContinuous({quotient topology in}Y{by}f,{quotient by}r,g)"
    using two_top_spaces0.cont_quotient_top assms(1) gg2 topSpaceAssum equiv_quo_is_top B
    unfolding two_top_spaces0_def by auto
  { fix x y assume T: "x\<in>Y" "y\<in>Y" "g`(x)=g`(y)"
    with assms(3) have "f``(f-``{x})=f``(f-``{y})" 
      using apply_equality gg by simp
    with assms(1) T(1,2) have "x=y" using surj_image_vimage by auto
  } with gg2 have "g\<in>inj(Y,\<Union>({quotient by}r))" unfolding inj_def by auto 
  moreover
  have "g O f\<in>surj(\<Union>T, (\<Union>T)//r)" using feq quotient_proj_surj by auto
  with ff gg B have "g\<in>surj(Y,\<Union>(T{quotient by}r))" 
    using comp_mem_surjD1 total_quo_equi by auto
  ultimately have "g\<in>bij(\<Union>({quotient topology in}Y{by}f),\<Union>({quotient by}r))" 
    unfolding bij_def using total_quo_func assms(1) by auto
  with gcont gopen show "IsAhomeomorphism(({quotient topology in}Y{by}f),({quotient by}r),g)"
    using bij_cont_open_homeo by auto
qed

text\<open>The mapping $\langle b,c \rangle \mapsto \langle r\{ a\},r\{ b\}\rangle$
  is a function that maps the product of the carrier by itself to the
  product of the quotients. Note $r$ does not have to be an equivalence relation. \<close>

lemma product_equiv_rel_fun:
  shows "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}:(\<Union>T\<times>\<Union>T)\<rightarrow>((\<Union>T)//r\<times>(\<Union>T)//r)"
proof-
  have " {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}\<in>\<Union>T\<rightarrow>(\<Union>T)//r" using quotient_proj_fun by auto 
  moreover have "\<forall>A\<in>\<Union>T. \<langle>A,r``{A}\<rangle>\<in>{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}" by auto
  ultimately have "\<forall>A\<in>\<Union>T. {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`A=r``{A}" using apply_equality by auto
  hence "{\<langle>\<langle>b,c\<rangle>,r``{b},r``{c}\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T} = 
    {\<langle>\<langle>x,y\<rangle>,{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`(x),{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`(y)\<rangle>. \<langle>x,y\<rangle>\<in>\<Union>T\<times>\<Union>T}"
    by force
  then show ?thesis using prod_fun quotient_proj_fun by auto
qed

text\<open>The mapping $\langle b,c \rangle \mapsto \langle r\{ a\},r\{ b\}\rangle$
  is a surjection of the product of the carrier by itself onto the
  carrier of the product topology. Again $r$ does not have to be an equivalence relation for this. \<close>

lemma (in topology0) prod_equiv_rel_surj:
  shows "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}\<in>surj(\<Union>(T\<times>\<^sub>tT),((\<Union>T)//r\<times>(\<Union>T)//r))"
proof-
  have 
    fun: "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}:(\<Union>T\<times>\<Union>T)\<rightarrow>((\<Union>T)//r\<times>(\<Union>T)//r)" 
      using product_equiv_rel_fun by auto 
  moreover
  { fix M assume "M\<in>((\<Union>T)//r\<times>(\<Union>T)//r)"
    then obtain M1 M2 where M: "M=\<langle>M1,M2\<rangle>" "M1\<in>(\<Union>T)//r""M2\<in>(\<Union>T)//r" by auto
    then obtain m1 m2 where m: "m1\<in>\<Union>T" "m2\<in>\<Union>T" "M1=r``{m1}" "M2=r``{m2}" 
      unfolding quotient_def by auto
    then have mm: "\<langle>m1,m2\<rangle>\<in>(\<Union>T\<times>\<Union>T)" by auto
    hence "\<langle>\<langle>m1,m2\<rangle>,\<langle>r``{m1},r``{m2}\<rangle>\<rangle>\<in>{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}" 
      by auto
    with fun have "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}`\<langle>m1,m2\<rangle>=\<langle>r``{m1},r``{m2}\<rangle>"
      using apply_equality by auto
    with M(1) m(3,4) mm have "\<exists>R\<in>(\<Union>T\<times>\<Union>T). {\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}`(R) = M"
      by auto
  }
  ultimately show ?thesis unfolding surj_def using Top_1_4_T1(3) topSpaceAssum 
    by auto
qed

text\<open>The product quotient projection (i.e. the mapping the mapping 
  $\langle b,c \rangle \mapsto \langle r\{ a\},r\{ b\}\rangle$ is continuous.\<close>

lemma (in topology0) product_quo_fun:
  assumes "equiv(\<Union>T,r)"
  shows 
    "IsContinuous(T\<times>\<^sub>tT,({quotient by} r)\<times>\<^sub>t({quotient by} r),{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T})"
proof-
  have "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}:\<Union>T\<rightarrow>(\<Union>T)//r" using quotient_proj_fun by auto
  moreover have "\<forall>A\<in>\<Union>T. \<langle>A,r``{A}\<rangle> \<in> {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}" by auto
  ultimately have "\<forall>A\<in>\<Union>T. {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`A=r``{A}" using apply_equality by auto
  hence IN: "{\<langle>\<langle>b,c\<rangle>,r``{b},r``{c}\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T} = 
    {\<langle>\<langle>x,y\<rangle>,{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}`(x),{\<langle>b,r``{b}\<rangle>.b\<in>\<Union>T}`(y)\<rangle>. \<langle>x,y\<rangle>\<in>\<Union>T\<times>\<Union>T}"
    by force
  with assms have cont: "IsContinuous(T,{quotient by}r,{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T})" 
    using quotient_func_cont quotient_proj_surj EquivQuo_def by auto
  with assms have  tot: "\<Union>(T{quotient by}r) = (\<Union>T) // r" and 
    top: "({quotient by}r) {is a topology}" 
    using total_quo_equi equiv_quo_is_top by auto 
  then have fun: "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}:\<Union>T\<rightarrow>\<Union>({quotient by}r)" using quotient_proj_fun 
    by auto
  then have "two_top_spaces0(T,{quotient by}r,{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T})" 
    unfolding two_top_spaces0_def using topSpaceAssum top by auto
  with fun cont top IN show ?thesis 
    using two_top_spaces0.product_cont_functions topSpaceAssum by auto
qed

text\<open>The product of quotient topologies is a quotient topology given that the
  quotient map is open. This isn't true in general.\<close>

theorem (in topology0) prod_quotient:
  assumes "equiv(\<Union>T,r)" "\<forall>A\<in>T. {\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}``(A) \<in> ({quotient by} r)"
  shows "(({quotient by} r)\<times>\<^sub>t{quotient by} r) = 
  ({quotient topology in} (((\<Union>T)//r)\<times>((\<Union>T)//r)) {by} ({\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}) {from} (T\<times>\<^sub>tT))"
proof
  let ?T\<^sub>r = "{quotient by} r"
  let ?R = "({quotient topology in} (((\<Union>T)//r)\<times>((\<Union>T)//r)) {by} ({\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}) {from} (T\<times>\<^sub>tT))"
  { fix A assume A: "A\<in>?T\<^sub>r\<times>\<^sub>t?T\<^sub>r"
    with assms(1) have "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}-``(A) \<in> T\<times>\<^sub>tT"
      using product_quo_fun unfolding IsContinuous_def by auto
    moreover 
    from A have "A\<subseteq>\<Union>((?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r))" by auto
    with assms(1) have "A\<in>Pow(((\<Union>T)//r)\<times>((\<Union>T)//r))"
      using Top_1_4_T1(3) equiv_quo_is_top total_quo_equi by auto
    ultimately have "A\<in>?R"
      using topology0.QuotientTop_def Top_1_4_T1(1) topSpaceAssum prod_equiv_rel_surj 
      unfolding topology0_def by auto
  } thus "(?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r) \<subseteq> ?R" by auto
  { fix A assume "A\<in>?R"
    with assms(1) have 
      A: "A \<subseteq> ((\<Union>T)//r)\<times>((\<Union>T)//r)" "{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}-``(A) \<in> T\<times>\<^sub>tT"
      using topology0.QuotientTop_def Top_1_4_T1(1) topSpaceAssum prod_equiv_rel_surj 
      unfolding topology0_def by auto
    { fix C assume "C\<in>A"
      with A(1) obtain C\<^sub>1 C\<^sub>2 where CC: "C=\<langle>C\<^sub>1,C\<^sub>2\<rangle>" "C\<^sub>1\<in>((\<Union>T)//r)" "C\<^sub>2\<in>((\<Union>T)//r)" by auto
      then obtain c\<^sub>1 c\<^sub>2 where CC1: "c\<^sub>1\<in>\<Union>T" "c\<^sub>2\<in>\<Union>T" and CC2: "C\<^sub>1=r``{c\<^sub>1}" "C\<^sub>2=r``{c\<^sub>2}" 
        unfolding quotient_def by auto
      with \<open>C\<in>A\<close> CC have "\<langle>c\<^sub>1,c\<^sub>2\<rangle>\<in>{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}-``(A)"
        using vimage_iff by auto
      with A(2) have 
        "\<exists>V W. V\<in>T \<and> W\<in>T \<and> V\<times>W \<subseteq> {\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}-``(A) \<and> \<langle>c\<^sub>1,c\<^sub>2\<rangle> \<in> V\<times>W"
         using prod_top_point_neighb topSpaceAssum by blast
       then obtain V W where 
         VW: "V\<in>T" "W\<in>T" "V\<times>W \<subseteq> {\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}-``(A)" "c\<^sub>1\<in>V" "c\<^sub>2\<in>W" 
         by blast
       let ?V\<^sub>r = "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}``(V)"
       let ?W\<^sub>r = "{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}``(W)"
       from VW assms have P: "(?V\<^sub>r\<times>?W\<^sub>r) \<in> (?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r)" 
          using prod_open_open_prod equiv_quo_is_top by auto
       { fix S assume "S\<in>(?V\<^sub>r\<times>?W\<^sub>r)"
         then obtain s\<^sub>1 s\<^sub>2 where S: "S=\<langle>s\<^sub>1,s\<^sub>2\<rangle>" "s\<^sub>1\<in>?V\<^sub>r" "s\<^sub>2\<in>?W\<^sub>r" 
           by blast
         then obtain t\<^sub>1 t\<^sub>2 where 
           T: "\<langle>t\<^sub>1,s\<^sub>1\<rangle>\<in>{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}" "\<langle>t\<^sub>2,s\<^sub>2\<rangle>\<in>{\<langle>b,r``{b}\<rangle>. b\<in>\<Union>T}" "t\<^sub>1\<in>V" "t\<^sub>2\<in>W" 
           using image_iff by auto
         with VW(3) have "\<exists>S\<^sub>0\<in>A. \<langle>\<langle>t\<^sub>1,t\<^sub>2\<rangle>,S\<^sub>0\<rangle>\<in>{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}" 
           using vimage_iff by auto
         then obtain S\<^sub>0 where "S\<^sub>0\<in>A" and 
           "\<langle>\<langle>t\<^sub>1,t\<^sub>2\<rangle>,S\<^sub>0\<rangle>\<in>{\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}" 
           by auto 
         moreover from S(1) T VW(1,2) have 
           "\<langle>\<langle>t\<^sub>1,t\<^sub>2\<rangle>,S\<rangle> \<in> {\<langle>\<langle>b,c\<rangle>,\<langle>r``{b},r``{c}\<rangle>\<rangle>. \<langle>b,c\<rangle>\<in>\<Union>T\<times>\<Union>T}"
            by auto
         ultimately have "S\<in>A" 
            using product_equiv_rel_fun unfolding Pi_def function_def
            by auto
        } hence sub: "?V\<^sub>r\<times>?W\<^sub>r \<subseteq> A" by blast
        from CC CC2 CC1 \<open>c\<^sub>1\<in>V\<close> \<open>c\<^sub>2\<in>W\<close> have "C \<in> ?V\<^sub>r\<times>?W\<^sub>r"
          using image_iff by auto
        with P sub have "\<exists>U\<in>(?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r). U\<subseteq>A \<and> C\<in>U  "
          by (rule witness_exists1)
      } hence "\<forall>C\<in>A. \<exists>U\<in>(?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r). C\<in>U \<and> U\<subseteq>A" 
          by blast
      with assms(1) have "A\<in>(?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r)" 
        using topology0.open_neigh_open Top_1_4_T1 equiv_quo_is_top assms
        unfolding topology0_def by auto
  } thus "?R \<subseteq> (?T\<^sub>r)\<times>\<^sub>t(?T\<^sub>r)" by auto
qed

end
