theory question_98_0

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  CelestialObject :: "entity ⇒ bool"
  Largest :: "entity ⇒ entity ⇒ bool"
  SolarSystem :: "entity"
  MadeOf :: "entity ⇒ entity ⇒ bool"
  Hydrogen :: "entity ⇒ bool"
  Helium :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Sun x"
  (* Hypothesis: The sun is made of hot gas and is the most massive object in our solar system. *)
  shows "∃y z. Star y ∧ CelestialObject z ∧ MadeOf x y ∧ PartOf y z ∧ Gas y ∧ Largest x z"
proof -
  from asm have "Star x" using explanation_1 by blast
  then have "CelestialObject x" using explanation_2 by blast
  then have "Gas y" if "MadeOf x y" for y using explanation_6 by auto
  then have "Gas x" if "MadeOf x x" using that by blast
  then have "Gas x" using explanation_5 by blast
  then have "Hot_gas x" using explanation_8 by blast
  then have "Largest x z" using explanation_3 by blast
  then show ?thesis using asm `x` by blast
qed

end
