theory question_87_1
imports Main

begin

typedecl entity
typedecl event

consts
  Limestone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  FoundIn :: "entity ⇒ entity ⇒ bool"
  Studying :: "entity ⇒ bool"
  History :: "entity ⇒ bool"
  LivingOrganisms :: "entity ⇒ bool"
  UsefulIn :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: limestone is a kind of sedimentary rock. *)
axiomatization where
  explanation_1: "∀x. Limestone x ⟶ SedimentaryRock x"

(* Explanation 2: nearly all fossils are found in sedimentary rock. *)
axiomatization where
  explanation_2: "∀x. Fossils x ⟶ (∃y. SedimentaryRock y ∧ FoundIn y x)"

theorem hypothesis:
  assumes asm: "Limestone z"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "UsefulIn z  Studying  History  LivingOrganisms"
proof -
  from asm have "SedimentaryRock z" using explanation_1 by simp
  then obtain y where y: "SedimentaryRock y ∧ FoundIn y (Fossils w)" for w using explanation_2 by blast
  then have "UsefulIn z Studying (History (LivingOrganisms v))" using y by simp
  then show ?thesis using asm by blast
qed

end
