theory question_30_1
imports Main

begin

typedecl entity
typedecl event

consts
  Human :: "entity ⇒ bool"
  Tricks :: "event ⇒ bool"
  Does :: "entity ⇒ event ⇒ bool"

(* Premise: John is a human. *)
assumes asm: "Human j"

(* Hypothesis: John does tricks. *)
shows "∃x. Human x ∧ Does x  Tricks e "

theorem hypothesis:
  assumes asm: "Human j"
  shows "∃x. Human x ∧ Does x (Tricks e)"
proof -
  have "Human j ∧ Does j (Tricks e)"
  proof -
    from asm have "Human j" by fact
    assume "Tricks e" (* we assume this for the purpose of deriving the required conclusion *)
    have "Does j (Tricks e)" using asm and this by (rule Does_def)
    from this and asm show "Human j ∧ Does j (Tricks e)" by blast
  qed

end
