theory question_13_6
imports Main

begin

typedecl entity
typedecl event

consts
  WeekendBarbecue :: "event ⇒ bool"
  Food :: "event ⇒ bool"
  Fish :: "entity ⇒ bool"
  IncludedIn :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A weekend barbecue includes food. *)
axiomatization where
  explanation_1: "∀e. WeekendBarbecue e ⟶ Food e"

(* Explanation 2: Food at a weekend barbecue can include fish. *)
axiomatization where
  explanation_2: "∀e. Food e ∧ WeekendBarbecue e ⟶ (∃f. Fish f ∧ IncludedIn f e)"

theorem hypothesis:
  (* Premise: Weekend barbecue with some fish. *)
  assumes asm: "WeekendBarbecue e ∧ Fish f ∧ IncludedIn f e"
  (* Hypothesis: Weekend barbecue with some fish *)
  shows "∃e. WeekendBarbecue e ∧ Fish e"
proof -
  from asm have "WeekendBarbecue e ∧ Fish f ∧ IncludedIn f e" by blast
  then have "WeekendBarbecue e" by blast
  then have "Food e" using explanation_1 by blast
  then have "∃f. Fish f ∧ IncludedIn f e" using explanation_2 asm by blast
  then show ?thesis using asm by blast
qed

end
