theory question_11_0
imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalConductor :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Plugged :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  CircuitCompleted :: "event ⇒ bool"
  CompleteElectricalCircuit :: "entity ⇒ bool"
  SourceOfElectricalEnergy :: "entity ⇒ bool"
  Electricity :: "event ⇒ bool"
  ElectricalEnergy :: "event ⇒ bool"
  Safe :: "entity ⇒ bool"
  Harm :: "entity ⇒ bool"
  Danger :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  One :: "entity ⇒ bool"
  Dangerous :: "event ⇒ bool"
  InDanger :: "entity ⇒ bool"
  Around :: "entity ⇒ entity ⇒ bool"
  Near :: "entity ⇒ entity ⇒ bool"
  Electrocution :: "event ⇒ bool"
  BodyOf :: "entity ⇒ entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  Organism :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Transferred :: "event ⇒ bool"
  CausesHarm :: "event ⇒ bool"
  Electrocuted :: "event ⇒ bool"

(* Explanation 1: when an electrical conductor is plugged into an outlet , a circuit is completed. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ElectricalConductor x ∧ Outlet y ∧ Plugged e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ CircuitCompleted e2"

(* Explanation 2: a complete electrical circuit is a source of electrical energy. *)
axiomatization where
  explanation_2: "∀x. CompleteElectricalCircuit x ⟶ SourceOfElectricalEnergy x"

(* Explanation 3: electricity means electrical energy. *)
axiomatization where
  explanation_3: "∀x. Electricity x ⟷ ElectricalEnergy x"

(* Explanation 4: safe is the opposite of harm; danger. *)
axiomatization where
  explanation_4: "∀x. Safe x ⟷ ¬(Harm x ∨ Danger x)"

(* Explanation 5: plugging many appliances into one outlet is dangerous. *)
axiomatization where
  explanation_5: "∀x y e. Appliances x ∧ Outlet y ∧ Plugged e ∧ Agent e x ∧ Patient e y ∧ Many x ∧ One y ⟶ Dangerous e"

(* Explanation 6: to be in danger means to be around; to be near something dangerous. *)
axiomatization where
  explanation_6: "∀x y e. InDanger x ⟷ (Around x y ∨ Near x y) ∧ Dangerous e ∧ Agent e y"

(* Explanation 7: electrocution causes harm to an organism. *)
axiomatization where
  explanation_7: "∀x y e. Electrocution e ∧ Agent e x ∧ Patient e y ∧ Organism y ⟶ CausesHarm e"

(* Explanation 8: if electricity flows through; is transferred through the body of an animal then that animal is electrocuted. *)
axiomatization where
  explanation_8: "∀x y e1 e2. Electricity e1 ∧ Flows e1 ∧ Agent e1 e1 ∧ Patient e1 x ∧ BodyOf x y ∧ Animal y ∧ Transferred e2 ∧ Agent e2 e1 ∧ Patient e2 x ⟶ Electrocuted e2 ∧ Agent e2 y"

(* Explanation 9: an animal is a kind of organism. *)
axiomatization where
  explanation_9: "∀x. Animal x ⟶ Organism x"

theorem hypothesis:
  assumes asm: "Appliances x ∧ Outlet y ∧ Plugged e ∧ Agent e x ∧ Patient e y ∧ Many x ∧ One y"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬ ∃e'. WayToStaySafe e' ∧ Agent e' x ∧ Patient e' Electricity "
proof -
  {
    assume "Appliances x ∧ Outlet y ∧ Plugged e ∧ Agent e x ∧ Patient e y ∧ Many x ∧ One y"
    then have "ElectricalConductor x ∧ Outlet y ∧ Plugged e ∧ Agent e x ∧ Patient e y"
      by (simp add: Appliances_def)
    then have "CircuitCompleted e'"
      using explanation_1 by blast
    then have "SourceOfElectricalEnergy e'"
      using explanation_2 by blast
    then have "ElectricalEnergy e'"
      using explanation_3 by blast
    then have "Electricity e'"
      using explanation_3 by blast
    then have "∃e'. Electricity e' ∧ Agent e' x"
      by blast
    then have "∃e'. Electricity e' ∧ Agent e' x ∧ Patient e' Electricity"
      by blast
    then have "Dangerous e'"
      using explanation_5 by blast
    then have "Danger y"
      using explanation_6 by blast
    then have "Harm y"
      using explanation_4 by blast
    then have "CausesHarm e''"
      using explanation_7 by blast
    then have "Electrocuted e''"
      using explanation_8 by blast
    then have "Organism x"
      using explanation_9 by blast
    then have "CausesHarm e'' ∧ Organism x"
      by blast
    then have "¬ WayToStaySafe e''"
      using explanation_4 by blast
    then have "¬ ∃e'. WayToStaySafe e' ∧ Agent e' x ∧ Patient e' Electricity"
      by blast
  }
  then show ?thesis
    using asm by blast
qed

end
