theory question_85_2
imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"
  PacinianCorpuscles :: "entity ⇒ bool"
  LocationProperty :: "(entity ⇒ bool) ⇒ entity ⇒ bool"
  SpecificType :: "(entity ⇒ bool)"
  Property :: "(entity ⇒ bool) ⇒ entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 2: Pacinian corpuscles are a specific type of pressure receptors and share the same location properties. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x ∧ (∀y. (LocationProperty y) x ⟷ (LocationProperty y) PressureReceptors)"

(* Explanation 3: All properties of pressure receptors, excluding their specific type, apply to Pacinian corpuscles. *)
axiomatization where
  explanation_3: "∀x y. (y ≠ SpecificType) ∧ (Property y) ∧ PressureReceptors x ⟶ (Property y) x"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  assume asm: "PacinianCorpuscles x"
  from asm have "PressureReceptors x" using explanation_2 by blast
  from this have "MainlyFoundIn x Skin" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
