theory question_17_4
imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  TrophicLevelOfEntity :: "entity ⇒ nat"
  Plants :: "entity ⇒ bool"
  Consume :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Many consumers, including omnivores, feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∀x e1 e2. Consumers x ∧ Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ Agent e1 x ∧ Agent e2 x ∧ TrophicLevelOfEntity x ≠ TrophicLevelOfEntity (THE y. Agent e1 y ∧ Patient e1 y)"

(* Explanation 2: Omnivores consume both plants (producers at the first trophic level) and other consumers (at various trophic levels), thereby feeding at multiple trophic levels. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Omnivores x ∧ Plants y ∧ Consumers y ∧ Consume e1 ∧ Feed e2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 y ∧ (TrophicLevelOfEntity y = 1 ∨ TrophicLevelOfEntity y ≠ 1) ∧ TrophicLevelOfEntity x ≠ TrophicLevelOfEntity (THE z. Agent e2 z ∧ Patient e2 z)"

theorem hypothesis:
  assumes asm: "Omnivores x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃e1 e2. Feed e1 ∧ Feed e2 ∧ Agent e1 x ∧ Agent e2 x ∧ TrophicLevelOfEntity x ≠ TrophicLevelOfEntity  THE y. Agent e1 y ∧ Patient e1 y "
proof -
  from asm have "Omnivores x" by simp
  {
    fix e1 y
    assume "Feed e1" "Agent e1 x" "Patient e1 y"
    have "TrophicLevelOfEntity x ≠ TrophicLevelOfEntity y" using explanation_1[OF this(2), of x e1] by blast
  }
  {
    fix e2 z
    assume "Feed e2" "Agent e2 x" "Patient e2 z" "Plants z"
    have "TrophicLevelOfEntity x ≠ TrophicLevelOfEntity z" using explanation_2[OF this(2-4), of x e2] by blast
  }
  {
    fix e2 z
    assume "Feed e2" "Agent e2 x" "Patient e2 z" "Consumers z"
    have "TrophicLevelOfEntity x ≠ TrophicLevelOfEntity z" using explanation_2[OF this(2-4), of x e2] by blast
  }
  then have "∃e1 e2 y. Feed e1 ∧ Feed e2 ∧ Agent e1 x ∧ Agent e2 x ∧ TrophicLevelOfEntity x ≠ TrophicLevelOfEntity y"
    by blast
  then show ?thesis by blast
qed

end
