theory question_51_0
imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Speech :: "event ⇒ bool"
  OrnateCostumeParty :: "entity ⇒ bool"
  Gives :: "entity ⇒ event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"
  PublicSpeaking :: "event ⇒ bool"

(* Explanation 1: If someone gives a speech that means that they are speaking. *)
axiomatization where
  explanation_1: "∀x e. Gives x e ∧ Speech e ⟶ Speaking e"

theorem hypothesis:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x ∧ Speech e ∧ OrnateCostumeParty y ∧ Gives x e ∧ Agent e x ∧ Patient e y ∧ At e y"
  (* Hypothesis: A man is public speaking. *)
  shows "∃x e. Man x ∧ PublicSpeaking e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Gives x e ∧ Speech e" by blast
  then have "Man x ∧ Speaking e" using explanation_1 by blast
  from asm have "At e y ∧ OrnateCostumeParty y" by blast
  then have "PublicSpeaking e" by blast
  from this and ‹Man x ∧ Speaking e› have "Man x ∧ PublicSpeaking e ∧ Agent e x" by blast
  then show ?thesis using asm by blast
qed

end
