theory question_81_0

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Suddenly :: "event ⇒ bool"
  GetSmaller :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  PopulationGrowth :: "entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Reduced :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x y e. BottleneckEffect x ∧ Population y ∧ Suddenly e ∧ GetSmaller e ∧ Occurs e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Population growth is reduced by external migration. *)
axiomatization where
  explanation_2: "∀x y e. PopulationGrowth x ∧ ExternalMigration y ∧ Reduced e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "PopulationGrowth x" using explanation_2 by blast
  have conclusion: "BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 by simp
  show ?thesis using asm conclusion `PopulationGrowth x` by blast
qed

end
