theory question_40_0

imports Main

begin

typedecl entity
typedecl event

consts
  LightBulbs :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Convert :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Energy :: "entity ⇒ bool"
  Same :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: some light bulbs convert electricity into light and heat energy *)
axiomatization where
  explanation_1: "∀x y e. LightBulbs x ∧ Electricity y ∧ Convert e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Electrical energy is also energy. *)
axiomatization where
  explanation_2: "∀x y. ElectricalEnergy x ∧ Energy y ∧ Same x y"

theorem hypothesis:
  assumes asm: "LightBulbs x ∧ Electricity y"
  (* Hypothesis: Some light bulbs convert other energy into light and heat energy. *)
  shows "∃x y e. Convert e ∧ Agent e x ∧ Patient e y ∧ ElectricalEnergy x ∧ Energy y"
proof -
  from asm have "LightBulbs x ∧ Electricity y" by simp
  then obtain e1 where e1: "Convert e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "ElectricalEnergy x ∧ Energy y" using explanation_2 by blast
  have conclusion: "Convert e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ElectricalEnergy x ∧ Energy y" using e1 by simp
  show ?thesis using asm conclusion `ElectricalEnergy x ∧ Energy y` by blast
qed

end
