theory question_90_0

imports Main

begin

typedecl entity
typedecl event

consts
 Worker :: "entity ⇒ bool"
 Grass :: "entity ⇒ bool"
 Pulling :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Workers are pulling grass while they bent over. *)
axiomatization where
 explanation_1: "∀x y e. Worker x ∧ Grass y ∧ Pulling e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
 (* Premise: Three workers bent over pulling grass. *)
 assumes asm: "Worker x  ∧ Grass y  ∧ Bent e1  ∧ Pulling e2  ∧ Agent e1  x  ∧ Agent e2  x  ∧ Patient e1  y  ∧ Patient e2  y "
 (* Hypothesis: Three workers bent over. *)
 shows "∃x y e. Worker x  ∧ Bent e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "Worker x" by blast
 from this have "Bent e" using explanation_1 by blast
 from asm have "Grass y" by blast
 from this have "Pulling e" using explanation_1 by blast
 show ?thesis using `Worker x` `Bent e` `Grass y` `Pulling e` by blast
qed

end
