theory question_27_1

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  DirtySidewalk :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"

(* Explanation 1: A man is outside if he is on a dirty sidewalk. *)
axiomatization where
  explanation_1: "∀x y. Man x ∧ On y ⟶ Outside y"

(* Explanation 2: A dirty sidewalk is outdoors. *)
axiomatization where
  explanation_2: "∀x. DirtySidewalk x ⟶ Outdoors x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ DirtySidewalk z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ In e z"
  (* Hypothesis: The man is outside. *)
  shows "∃x y e. Man x ∧ Outside y ∧ Sells e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "OldMan x" by blast
  from this have "Man x" using explanation_1 by blast
  from asm have "DirtySidewalk z" by blast
  from this have "Outside y" using explanation_1 by blast
  show ?thesis using `Man x` `Outside y` by blast
qed

end
