theory question_60_2
imports Main
begin

typedecl entity
typedecl event

consts
  PhaseChanges :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Occurred :: "event ⇒ bool"
  Ice :: "entity ⇒ bool"
  Solid :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  HeatEnergy :: "event ⇒ bool"
  Melts :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Changes :: "event ⇒ bool"
  Adding :: "event ⇒ bool"
  Melting :: "event ⇒ bool"
  PhaseChange :: "event ⇒ bool"
  Weight :: "entity ⇒ bool"
  PropertyOf :: "entity ⇒ entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  Objects :: "entity ⇒ bool"
  Materials :: "entity ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Windowsill :: "entity ⇒ bool"
  Containing :: "event ⇒ bool"
  Placed :: "event ⇒ bool"

(* Explanation 1: phase changes do not change mass. *)
axiomatization where
  explanation_1: "∀x y e. PhaseChanges x ∧ Mass y ∧ Change e ∧ Patient e y ⟶ ¬Occurred e"

(* Explanation 2: When ice melts, it changes from a solid into a liquid by adding heat energy. Ice is the agent of the melting event. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Ice x ∧ Solid y ∧ Liquid z ∧ HeatEnergy e3 ∧ Melts e1 ∧ Agent e1 x ∧ Changes e2 ∧ Patient e2 y ∧ Patient e2 z ∧ Adding e3 ∧ Agent e1 e3 ∧ Patient e3 e2"

(* Explanation 3: melting is a kind of phase change. *)
axiomatization where
  explanation_3: "∀x. Melting x ⟶ PhaseChange x"

(* Explanation 4: mass; weight is a property of matter; objects; materials. *)
axiomatization where
  explanation_4: "∀x y. (Mass x ∨ Weight x) ⟶ (PropertyOf x y ∧ (Matter y ∨ Objects y ∨ Materials y))"

theorem hypothesis:
  (* Premise: a beaker containing 50 milliliters of ice is placed on a windowsill. *)
  (* Premise: after several hours, the ice melts. *)
  assumes asm: "Beaker x ∧ Ice y ∧ Windowsill z ∧ Containing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Placed e2 ∧ Agent e2 x ∧ Patient e2 z" 
                "∃x e. Ice x ∧ Melts e ∧ Agent e x"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "∃x y e1 e2. Ice x ∧ Mass y ∧ Melted e1 ∧ Agent e1 x ∧ Change e2 ∧ Patient e2 y ∧ ¬Occurred e2"
proof -
  from asm obtain x e where ice_melt: "Ice x ∧ Melts e ∧ Agent e x" by blast
  then have "PhaseChange e" using explanation_3 by blast
  then obtain y where mass_y: "Mass y" using explanation_4 by blast
  then have "Change e ∧ Patient e y ⟶ ¬Occurred e" using explanation_1 by blast
  then have "¬Occurred e" using ice_melt mass_y by blast
  show ?thesis using ice_melt mass_y `¬Occurred e` by blast
qed

end
