theory question_85_9

imports Main

begin
typedecl entity
typedecl event

consts
  Vendor :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A vendor on the sidewalk with a flower cart is a flower seller. *)
axiomatization where
  explanation_1: "∀x y z. Vendor x ∧ Sidewalk y ∧ FlowerCart z ∧ On x y ∧ With x z ⟶ FlowerSeller x"

(* Explanation 2: If a flower seller is on the sidewalk, then the flower seller is also on the sidewalk. *)
axiomatization where
  explanation_2: "∀x y. FlowerSeller x ∧ Sidewalk y ∧ On x y ⟶ On x y"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ Sidewalk y ∧ FlowerCart z ∧ On x y ∧ With x z"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor x ∧ Sidewalk y ∧ FlowerCart z ∧ On x y ∧ With x z" by blast
  then have "FlowerSeller x ∧ Sidewalk y ∧ On x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
