theory question_85_4

imports Main

begin
typedecl entity

consts
  Vendor :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A vendor with a flower cart is a flower seller. *)
axiomatization where
  explanation_1: "∀x y. Vendor x ∧ FlowerCart y ∧ With x y ⟶ FlowerSeller x"

(* Explanation 2: A flower seller on the sidewalk is a flower seller who is on the sidewalk. *)
axiomatization where  
  explanation_2: "∀x y. FlowerSeller x ∧ Sidewalk y ⟶ On x y"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ On x z"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor x ∧ FlowerCart y ∧ With x y" by blast
  then have "FlowerSeller x" using explanation_1 by blast
  from asm have "Sidewalk z" by blast
  then have "On x z" using `FlowerSeller x` explanation_2 by blast
  then show ?thesis using `FlowerSeller x` `Sidewalk z` `On x z` by blast
qed

end
