theory question_85_0
imports Main

begin
typedecl entity

consts
  Vendor :: "entity ⇒ bool"
  Seller :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"

(* Explanation 1: Vendor is a seller *)
axiomatization where
  explanation_1: "∀x. Vendor x ⟶ Seller x"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Sidewalk x ∧ FlowerCart y ∧ Vendor z ∧ On y x ∧ Seller z"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor z ∧ Sidewalk x ∧ On z x" by blast
  then have "Seller z ∧ Sidewalk x ∧ On z x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
