theory question_93_0

imports Main

begin

typedecl entity
typedecl event

consts
  Echinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "event ⇒ bool"
  Have :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Represented :: "entity ⇒ entity ⇒ bool"
  StarfishAdults :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x e. Echinoderms x ∧ RadialSymmetry e ∧ Have e ∧ Agent e x"

(* Explanation 2: Echinoderms are represented by the starfish. *)
axiomatization where
  explanation_2: "∀x y. Echinoderms x ∧ Starfish y ⟶ Represented x y"

theorem hypothesis:
  assumes asm: "StarfishAdults x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "∃x e. StarfishAdults x ∧ RadialSymmetry e ∧ Have e ∧ Agent e x"
proof -
  from asm have "StarfishAdults x" by simp
  then obtain e where e: "RadialSymmetry e ∧ Have e ∧ Agent e x" using explanation_1 by blast
  then obtain y where y: "Echinoderms y ∧ Represented y x" using explanation_2 by blast
  have conclusion: "RadialSymmetry e ∧ Have e ∧ Agent e x" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
