theory question_41_6

imports Main

begin

typedecl entity
typedecl event

consts
  EarthTilt :: "event ⇒ bool"
  RotatingAxis :: "event ⇒ bool"
  Causes :: "event ⇒ bool"
  ChangesInWeather :: "event ⇒ bool"
  OverTime :: "event ⇒ bool"
  ChangesInWeatherPatterns :: "event ⇒ bool"
  Indirectly :: "event ⇒ bool"

(* Explanation 1: Earth's tilt on its rotating axis causes changes in weather over time. *)
axiomatization where
  explanation_1: "∀e. EarthTilt e ∧ RotatingAxis e ⟶ (∃e1. Causes e1 ∧ ChangesInWeather e1 ∧ OverTime e1)"

(* Explanation 2: Earth's tilt on its rotating axis causes changes in weather patterns indirectly. *)
axiomatization where
  explanation_2: "∀e. EarthTilt e ∧ RotatingAxis e ⟶ (∃e1. Causes e1 ∧ ChangesInWeatherPatterns e1 ∧ Indirectly e1)"

theorem hypothesis:
  assumes asm: "EarthTilt e ∧ RotatingAxis e"
  (* Hypothesis: Earth's tilt on its rotating axis causes changes in weather. *)
  shows "∃e1. Causes e1 ∧ ChangesInWeather e1"
proof -
  from asm have "EarthTilt e ∧ RotatingAxis e" by simp
  then obtain e1 where e1: "Causes e1 ∧ ChangesInWeather e1" using explanation_1 by blast
  have conclusion: "Causes e1 ∧ ChangesInWeather e1" using e1 by simp
  show ?thesis using conclusion by blast
qed

end
