theory question_89_0
imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Bikes :: "entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Generic :: "entity ⇒ bool"
  Called :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  AnotherWordFor :: "entity ⇒ entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  In :: "entity ⇒ event ⇒ bool"

(* Explanation 1: Mountain biking uses bikes and can thus be generically called bicycling. The woods is another word for forest. Autumn is another word for the season of fall. *)
axiomatization where
  explanation_1: "∀x y z e. MountainBiking x ∧ Bikes y ∧ Bicycling z ∧ Generic z ∧ Called e ∧ Agent e x ∧ Patient e z ∧ AnotherWordFor x z ∧ AnotherWordFor y z"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking e ∧ Woods x ∧ Autumn y ∧ In x e ∧ In y e"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling e ∧ Woods x ∧ Autumn y ∧ In x e ∧ In y e"
proof -
  from asm have "MountainBiking e ∧ Bikes x ∧ Bicycling z ∧ Generic z ∧ Called y ∧ Agent y e ∧ Patient y z ∧ AnotherWordFor e x ∧ AnotherWordFor x z" by blast
  then have "Bicycling e ∧ Woods x ∧ Autumn z ∧ In x e ∧ In z e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
